(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    255440,       5664]
NotebookOptionsPosition[    250546,       5535]
NotebookOutlinePosition[    251693,       5575]
CellTagsIndexPosition[    251650,       5572]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[Cell[TextData[{
  StyleBox[" Integration Rules for \n",
   FontSize->24],
  Cell[BoxData[
   FormBox[
    RowBox[{"\[Integral]", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         SuperscriptBox["sin", "j"], "(", "z", ")"}], ")"}], "m"], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{
          SuperscriptBox["sin", "k"], "(", "z", ")"}]}], "+", 
        RowBox[{"C", " ", 
         RowBox[{
          SuperscriptBox["sin", 
           RowBox[{"2", "k"}]], "(", "z", ")"}]}]}], ")"}], 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{
           SuperscriptBox["sin", "k"], "(", "z", ")"}]}]}], ")"}], "n"], 
      RowBox[{"\[DifferentialD]", "z"}]}]}], TraditionalForm]]],
  " when ",
  Cell[BoxData[
   FormBox[
    RowBox[{
     SuperscriptBox["j", "2"], "=", 
     RowBox[{
      RowBox[{"1", "\[And]", 
       SuperscriptBox["k", "2"]}], "=", 
      RowBox[{
       RowBox[{"1", "\[And]", 
        SuperscriptBox["a", "2"]}], "=", 
       SuperscriptBox["b", "2"]}]}]}], TraditionalForm]]]
 }], "Title",
  CellChangeTimes->{{3.504728397846987*^9, 3.5047284092870026`*^9}, {
    3.504728482957106*^9, 3.504728547407196*^9}, {3.504728775837516*^9, 
    3.5047288084075613`*^9}, 3.5047292797082214`*^9, 3.504729323748283*^9},
  TextAlignment->Center,
  FontFamily->"Arial",
  FontSize->20,
  FontWeight->"Plain"]], "Title",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.4984957111631136`*^9, 
   3.498495721365532*^9}, {3.4986732307820587`*^9, 3.49867323910207*^9}, {
   3.498673734862764*^9, 3.4986737418127737`*^9}, {3.4987611709121957`*^9, 
   3.4987611709121957`*^9}, {3.4991793560969815`*^9, 3.4991793629141936`*^9}, 
   3.499180198971263*^9, {3.499212131231846*^9, 3.4992121419018607`*^9}, {
   3.5003179772333093`*^9, 3.500317978075711*^9}, {3.500320981636481*^9, 
   3.500320982366482*^9}, 3.5003435061162395`*^9, {3.5019004360235157`*^9, 
   3.5019004396583223`*^9}, {3.5047236155802917`*^9, 
   3.5047236282803097`*^9}, {3.504723727200448*^9, 3.504723780090522*^9}, {
   3.504723822970582*^9, 3.504723881460664*^9}, {3.504724096730965*^9, 
   3.5047240982609673`*^9}, {3.504724618881696*^9, 3.5047246550617466`*^9}, {
   3.50472542886283*^9, 3.5047254304228325`*^9}, {3.504725613093088*^9, 
   3.5047256184130955`*^9}, 3.5047256790531807`*^9, {3.504725770413308*^9, 
   3.504725777993319*^9}, {3.5047268667348433`*^9, 3.504726874574854*^9}, {
   3.504726915284911*^9, 3.504726932884936*^9}, {3.5047269661849823`*^9, 
   3.504726979615001*^9}, 3.5047297320788546`*^9, {3.5047297818889246`*^9, 
   3.504729789428935*^9}, {3.504730479679901*^9, 3.50473049306992*^9}, {
   3.504730553910005*^9, 3.5047305599300137`*^9}, {3.5053445982237234`*^9, 
   3.5053445999937263`*^9}, {3.510019993526675*^9, 3.510020042853962*^9}, {
   3.510166795591646*^9, 3.510166795591646*^9}, {3.5101703892452135`*^9, 
   3.5101703892452135`*^9}, {3.5133570801645327`*^9, 3.5133570801645327`*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->24,
 FontWeight->"Plain"],

Cell[CellGroupData[{

Cell["Domain Map", "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.497986248409831*^9, 
   3.497986248831032*^9}, {3.498495555818041*^9, 3.4984955663948593`*^9}, {
   3.498673619942603*^9, 3.498673628882616*^9}, {3.498673758742798*^9, 
   3.4986737649728065`*^9}, {3.5023763566098824`*^9, 3.502376360556689*^9}, {
   3.5025030477127104`*^9, 3.502503050973116*^9}, 3.5032820316843176`*^9, {
   3.5045512239492745`*^9, 3.504551248149308*^9}, {3.5051985130925627`*^9, 
   3.505198513541588*^9}, {3.505366069986941*^9, 3.505366070216941*^9}, {
   3.513366223994636*^9, 3.5133662302646446`*^9}, {3.5133758176228995`*^9, 
   3.5133758179037*^9}, {3.513800711960678*^9, 3.513800720821185*^9}},
 TextAlignment->Center,
 FontFamily->"Arial",
 FontSize->20],

Cell[BoxData[
 GraphicsBox[{
   {RGBColor[1, 0, 0], RectangleBox[{-4, -4}, {-1, 4}]}, 
   {GrayLevel[0], InsetBox[
     StyleBox["\<\"Rule 1 \[RightArrow]\[Diamond]\"\>",
      StripOnInput->False,
      FontSize->10], NCache[{Rational[-5, 2], 2}, {-2.5, 2}]]}, 
   {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
    LineBox[{{-1.02, 3.98}, {-1.02, -3.98}}], 
    {RGBColor[1, 0, 1], Dashing[{}], RectangleBox[{-1, -4}, {4, -1}], 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 2 \[UpArrow]\[Diamond]\"\>",
        StripOnInput->False,
        FontSize->10], NCache[{2, Rational[-5, 2]}, {2, -2.5}]]}, 
     {RGBColor[0, 1, 0], RectangleBox[{-1, -1}, {4, 4}]}, 
     {GrayLevel[0], InsetBox[
       StyleBox["\<\"Rule 3\[Diamond]\"\>",
        StripOnInput->False,
        FontSize->10], {2, 2}]}, 
     {GrayLevel[0], Thickness[0.007], Dashing[{0.003, 0.02}], 
      LineBox[{{-1.02, -0.98}, {3.98, -0.98}}]}, 
     {RGBColor[0.5, 0.5, 1.], Thickness[Large], Dashing[{}], 
      LineBox[{{-3.98, 0}, {-1.02, 0}}], 
      {GrayLevel[0], InsetBox[
        StyleBox["\<\"Rule 4 \[RightArrow]\[Diamond]\"\>",
         StripOnInput->False,
         FontSize->10], NCache[{Rational[-5, 2], 0.13}, {-2.5, 0.13}]]}, 
      {GrayLevel[0], Thickness[Large], LineBox[{{-1, 0}, {3.98, 0}}]}}}}},
  Axes->True,
  AxesLabel->{
    FormBox["n", TraditionalForm], 
    FormBox[
     RowBox[{"j", " ", "k", " ", "m"}], TraditionalForm]},
  ImageSize->Medium]], "Input",
 TextAlignment->Center],

Cell[TextData[{
 StyleBox["Legend:",
  FontWeight->"Bold"],
 "\n\[Bullet]  The rule number in a colored region indicates the rule to use \
for integrals in that region.\n\[Bullet]  The rule number next to a colored \
line indicates the rule to use for integrals on that line.\n\[Bullet]  A \
white region or line indicates there is no rule for integrals in that region \
or on that line.\n\[Bullet]  A solid black line indicates integrals on that \
line are handled by rules in another section.\n\[Bullet]  A dashed black line \
on the border of a region indicates integrals on that border are handled by \
the rule for that region.\n\[Bullet]  The arrow(s) following a rule number \
indicates the direction the rule drives integrands in the n\[Cross]m exponent \
plane.\n\[Bullet]  A \[Diamond] following a rule number indicates the rule \
transforms the integrand into a form handled by another section.\n\[Bullet]  \
A red (stop) disk indicates the terminal rule to use for the point at the \
center of the disk.\n\[Bullet]  A cyan disk indicates the non-terminal rule \
to use for the point at the center of the disk."
}], "Text",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBWIQvWx2qt8BmVeOAtpmKSBazPxXBoguPqZWAKJ3VvSW
gGje1yvrQXTvPN4WEL3DULwVRHNs1u0G0VVfRSeD6EsSC6eD6FV9WrNAtOHV
+HkgWv9Q6k4QHetWuh9EH7w48QCIdohIPgqin689BaaXtdWcBdEb3DovgOjl
RslXQHQI+4X7IPr7BK7nINq2WwJMfxN6/hpEt0g2vAfRR7xefgbRXudamA4C
6WcX4tlBtAzPSx4QbVPAJwSir/yqkwLROQtY5EG0j6SgFohmi8k0AdH7HrBZ
gOjD1z65gOiAl39dQfTDAstoEB2x+BuY7v4bmg6i5+RVgWkAeVypcw==
  "],
 FontSize->14],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["a",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.497921629690209*^9, 3.5044699336788254`*^9, 
   3.505344687643849*^9, 3.5098471273584266`*^9, 3.510455454063097*^9, {
   3.510508517152938*^9, 3.5105085195397425`*^9}, {3.5105097842339635`*^9, 
   3.510509821720829*^9}, {3.5105098564932904`*^9, 3.5105098598316965`*^9}, {
   3.512256142654321*^9, 3.512256144947525*^9}, {3.5122561871143994`*^9, 
   3.512256229733674*^9}, {3.5144137669500422`*^9, 3.514413768119109*^9}, {
   3.5144144744945116`*^9, 3.5144144750495434`*^9}, 3.514737717221733*^9, 
   3.5147609139057913`*^9, {3.5151888059044104`*^9, 3.515188807184412*^9}, {
   3.5151888596944857`*^9, 3.5151888821345167`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic expansion", "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}, {
   3.51198092332861*^9, 3.5119809284639034`*^9}, {3.513609260172001*^9, 
   3.513609261622803*^9}}],

Cell[TextData[{
 "Basis: ",
 Cell[BoxData[
  RowBox[{
   FractionBox[
    RowBox[{"A", "+", 
     RowBox[{"B", " ", "z"}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox["z", "2"]}]}], 
    RowBox[{"a", "+", 
     RowBox[{"b", " ", "z"}]}]], "=", 
   RowBox[{
    FractionBox["A", "a"], "-", 
    FractionBox[
     RowBox[{"z", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", " ", "A"}], "-", 
        RowBox[{"a", " ", "B"}], "-", 
        RowBox[{"a", " ", "C", " ", "z"}]}], ")"}]}], 
     RowBox[{"a", 
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", "z"}]}], ")"}]}]]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, {3.497662072225127*^9, 3.497662138852844*^9}, 
   3.497662667553373*^9, {3.4976642890046206`*^9, 3.497664308286255*^9}, {
   3.497664560788298*^9, 3.4976645733775206`*^9}, {3.4979867025546293`*^9, 
   3.4979867054094343`*^9}, {3.510456932005166*^9, 3.510456936635173*^9}, {
   3.5136092874564486`*^9, 3.5136093125100927`*^9}, {3.514759160941328*^9, 
   3.5147592138814025`*^9}, {3.514760002292506*^9, 3.514760015232524*^9}}],

Cell[TextData[{
 "Note: The rule for integrands of the same form when ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "\[NotEqual]", "0"}]]],
 " could subsume this rule, but the resulting antiderivative will look less \
like the integrand involving sines instead of cosecants."
}], "Subsubsection",
 CellChangeTimes->{
  3.479686820458373*^9, {3.490657960122612*^9, 3.49065796095366*^9}, 
   3.4964414996009283`*^9, {3.4964447088058186`*^9, 3.4964447131058245`*^9}, 
   3.496528844063812*^9, 3.497575950496916*^9, 3.4975775797018027`*^9, 
   3.497639496888481*^9, 3.4976636252234545`*^9, {3.4979864214265356`*^9, 
   3.497986422409337*^9}, {3.4979866389377174`*^9, 3.49798665193254*^9}, {
   3.51198092332861*^9, 3.5119809284639034`*^9}, {3.513609260172001*^9, 
   3.513609261622803*^9}, {3.5147594629917507`*^9, 3.514759580281915*^9}, {
   3.5147596147519636`*^9, 3.5147597089720955`*^9}, {3.514759751312155*^9, 
   3.5147598248822575`*^9}, 3.514760128792683*^9}],

Cell[TextData[{
 "Rule a: If ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4982408115335917`*^9, 
   3.4982408115335917`*^9}, {3.504396309416292*^9, 3.5043963109862947`*^9}, {
   3.504413193550866*^9, 3.5044131942308674`*^9}, {3.5044133130510335`*^9, 
   3.504413313411034*^9}, {3.508348841306343*^9, 3.508348842436345*^9}, {
   3.513095047017943*^9, 3.5130950482379446`*^9}, {3.513377117822339*^9, 
   3.51337711822234*^9}, {3.514597917336328*^9, 3.5145979175763283`*^9}, {
   3.5145980146964645`*^9, 3.5145980151564655`*^9}, {3.5147364697159986`*^9, 
   3.5147364746612077`*^9}, {3.5147576755792484`*^9, 
   3.5147576761892495`*^9}, {3.5147590440111647`*^9, 3.514759050301173*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      FractionBox[
       RowBox[{"A", " ", "x"}], "a"]}]}]}]}], "+", 
  RowBox[{
   FractionBox["C", "b"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"Csc", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", " ", "x"}]}], "]"}], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}], "-", 
  RowBox[{
   FractionBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", "A"}], "-", 
      RowBox[{"a", " ", "B"}], "+", 
      RowBox[{"b", " ", "C"}]}], ")"}], "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"Csc", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579723816*^9, 3.4796580261689425`*^9}, 
   3.479661191290163*^9, {3.479686720164157*^9, 3.479686720204214*^9}, {
   3.479686831554328*^9, 3.479686834819022*^9}, {3.4940970712485504`*^9, 
   3.4940971130286083`*^9}, 3.4940971455886545`*^9, 3.49644160092107*^9, 
   3.496441663571158*^9, {3.496528814953771*^9, 3.4965288223737817`*^9}, 
   3.497576045657049*^9, 3.497576089857111*^9, 3.4975776169418545`*^9, {
   3.497577677171939*^9, 3.497577691381959*^9}, {3.4976395112561064`*^9, 
   3.4976395477133703`*^9}, {3.49766342891271*^9, 3.497663457772761*^9}, {
   3.497663580747777*^9, 3.497663583134581*^9}, {3.4979870210135884`*^9, 
   3.497987022604791*^9}, {3.498761170922196*^9, 3.498761170922196*^9}, {
   3.4987623460938416`*^9, 3.498762351773849*^9}, {3.498771763207025*^9, 
   3.498771766317029*^9}, {3.499176679905081*^9, 3.4991767019167194`*^9}, {
   3.4991769134450912`*^9, 3.4991769208239045`*^9}, {3.499177089507001*^9, 
   3.4991770988514175`*^9}, {3.4991771440134964`*^9, 3.49917724823728*^9}, {
   3.49917733957544*^9, 3.499177343725047*^9}, {3.499177507728135*^9, 
   3.4991775227821617`*^9}, {3.4991958536064606`*^9, 
   3.4991958550572634`*^9}, {3.4991964253402653`*^9, 3.499196426213866*^9}, {
   3.499220611573718*^9, 3.499220621053732*^9}, {3.499220791953971*^9, 
   3.4992208047139883`*^9}, {3.499220842934042*^9, 3.499220858054063*^9}, {
   3.49922124888461*^9, 3.4992212502446127`*^9}, {3.506011634305239*^9, 
   3.506011658545273*^9}, {3.506016286753561*^9, 3.506016298583578*^9}, {
   3.506017364036765*^9, 3.506017388996809*^9}, {3.507168650069973*^9, 
   3.507168654459979*^9}, {3.5107903473316607`*^9, 3.5107903569216743`*^9}, 
   3.510791815495717*^9, {3.510791877225804*^9, 3.5107918796458073`*^9}, {
   3.5107919206958647`*^9, 3.5107919361058865`*^9}, {3.5107929340912857`*^9, 
   3.51079296574133*^9}, {3.510793049051447*^9, 3.510793057921459*^9}, {
   3.510793103201523*^9, 3.5107931037715235`*^9}, {3.510793310961814*^9, 
   3.510793315101819*^9}, {3.5107941453949833`*^9, 3.5107941500049896`*^9}, {
   3.5119771197170563`*^9, 3.5119771289415836`*^9}, {3.5119771901660852`*^9, 
   3.511977201231718*^9}, {3.511977716092167*^9, 3.511977740172544*^9}, {
   3.514228039918445*^9, 3.514228057593276*^9}, {3.5142280888869314`*^9, 
   3.514228135577813*^9}, 3.5142282080867405`*^9, {3.514672388346424*^9, 
   3.5146724187764664`*^9}, {3.5147585489404716`*^9, 3.514758601890546*^9}, {
   3.5147588912009506`*^9, 3.5147589126109805`*^9}, {3.5147590846712217`*^9, 
   3.514759095171236*^9}, {3.514759882852339*^9, 3.5147598918923516`*^9}, {
   3.514763162406945*^9, 3.514763233897045*^9}, {3.5151888324544477`*^9, 
   3.515188849844472*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.4991772959421635`*^9, 3.4991773069401827`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "+", " ", "\n", "  ", 
    RowBox[{
     RowBox[{"C", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ",", "x"}], "]"}]}], " ", "-", " ", 
    "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "-", 
        RowBox[{"a", "*", "B"}], "+", 
        RowBox[{"b", "*", "C"}]}], ")"}], "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510794163895009*^9, 3.510794191825048*^9}, {3.510799222156905*^9, 
   3.51079923293692*^9}, {3.5107997631276627`*^9, 3.5107997707176733`*^9}, {
   3.5119751566217732`*^9, 3.511975166603344*^9}, {3.5119773763147326`*^9, 
   3.511977414069892*^9}, {3.511977770474277*^9, 3.5119777943976455`*^9}, 
   3.5136238769667764`*^9, 3.514228331498557*^9, 3.514228377971039*^9, 
   3.5142284547543736`*^9, 3.5142599325071144`*^9, 3.5146397041252065`*^9, {
   3.5146724267064776`*^9, 3.5146724713565397`*^9}, 3.514757729719324*^9, {
   3.5147593266915603`*^9, 3.514759364801614*^9}, {3.5147598997123623`*^9, 
   3.5147599182923884`*^9}, {3.514760935905822*^9, 3.514760937405824*^9}, 
   3.514763403827283*^9, {3.515976855988265*^9, 3.5159768618070755`*^9}},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"a_", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"x", "/", "a"}]}], " ", "+", " ", 
    RowBox[{
     RowBox[{"C", "/", "b"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", 
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}]}], ",", "x"}], "]"}]}], " ", "-", " ", 
    "\n", "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"b", "*", "A"}], "+", 
        RowBox[{"b", "*", "C"}]}], ")"}], "/", "a"}], "*", 
     RowBox[{"Int", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}], "/", 
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", 
            RowBox[{"(", 
             RowBox[{"-", "1"}], ")"}]}]}]}], ")"}]}], ",", "x"}], "]"}]}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097165958683*^9, 3.4940971894087152`*^9}, {
   3.4940972668388243`*^9, 3.4940972723188314`*^9}, 3.4964415782510386`*^9, 
   3.4965287890937347`*^9, 3.4975759366868963`*^9, 3.497577547811758*^9, 
   3.49758349857209*^9, 3.4976394822868557`*^9, 3.497663384967433*^9, {
   3.4976635889065914`*^9, 3.497663592322997*^9}, {3.4979870291256027`*^9, 
   3.4979870422296257`*^9}, {3.497987678082342*^9, 3.497987689735563*^9}, {
   3.4979879183851643`*^9, 3.4979879218639708`*^9}, 3.497988073511837*^9, 
   3.4984970174250083`*^9, {3.4987611709321957`*^9, 3.4987611709321957`*^9}, {
   3.498762437503969*^9, 3.498762476604024*^9}, {3.498762534054104*^9, 
   3.4987625544741325`*^9}, {3.4987718156570983`*^9, 3.498771821157106*^9}, 
   3.499176757172016*^9, 3.499177473610875*^9, {3.499177533998582*^9, 
   3.4991775542474174`*^9}, {3.499185447236084*^9, 3.4991854476572847`*^9}, {
   3.4991867525007772`*^9, 3.4991867535459795`*^9}, {3.499221289154667*^9, 
   3.4992213232347145`*^9}, 3.5060117270153685`*^9, {3.506011884195589*^9, 
   3.506011911555627*^9}, {3.506016315403601*^9, 3.506016334533628*^9}, {
   3.5060164328137655`*^9, 3.5060164512337914`*^9}, {3.506017490787389*^9, 
   3.506017520833041*^9}, {3.507169195320736*^9, 3.507169237320795*^9}, {
   3.5107903649416857`*^9, 3.510790414641755*^9}, {3.5107914373131866`*^9, 
   3.510791440833192*^9}, {3.5107918503857665`*^9, 3.5107918531657705`*^9}, {
   3.510792015105997*^9, 3.510792064656066*^9}, {3.5107921207661448`*^9, 
   3.5107921449961786`*^9}, {3.5107922428463154`*^9, 
   3.5107922587363377`*^9}, {3.510792532578723*^9, 3.51079253780873*^9}, {
   3.510792628798857*^9, 3.510792635248866*^9}, {3.5107929359612885`*^9, 
   3.5107929415412965`*^9}, {3.5107929894213634`*^9, 3.510793020761407*^9}, {
   3.5107933579518795`*^9, 3.510793360861883*^9}, {3.5107934219719687`*^9, 
   3.510793434731987*^9}, {3.5107934832620544`*^9, 3.510793511982095*^9}, {
   3.510794163895009*^9, 3.510794191825048*^9}, {3.510799222156905*^9, 
   3.51079923293692*^9}, {3.5107997631276627`*^9, 3.5107997707176733`*^9}, {
   3.5119751566217732`*^9, 3.511975166603344*^9}, {3.5119773763147326`*^9, 
   3.511977414069892*^9}, {3.511977770474277*^9, 3.5119777943976455`*^9}, 
   3.5136238769667764`*^9, 3.514228331498557*^9, 3.514228377971039*^9, 
   3.5142284547543736`*^9, 3.5142599325071144`*^9, 3.5146397041252065`*^9, {
   3.5146724267064776`*^9, 3.5146724713565397`*^9}, 3.514757729719324*^9, {
   3.5147593266915603`*^9, 3.514759364801614*^9}, {3.5147598997123623`*^9, 
   3.5147599182923884`*^9}, {3.514760935905822*^9, 3.514760937405824*^9}, 
   3.514763403827283*^9, {3.514763443907339*^9, 3.514763452337351*^9}, {
   3.5159768673606853`*^9, 3.515976867969086*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["b",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{"A", "+", 
       RowBox[{"B", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
       RowBox[{"C", " ", 
        SuperscriptBox[
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.497986248409831*^9, 
   3.497986248831032*^9}, {3.498495555818041*^9, 3.4984955663948593`*^9}, {
   3.498673619942603*^9, 3.498673628882616*^9}, {3.498673758742798*^9, 
   3.4986737649728065`*^9}, {3.5023763566098824`*^9, 3.502376360556689*^9}, {
   3.5025030477127104`*^9, 3.502503050973116*^9}, 3.5032820316843176`*^9, {
   3.5045512239492745`*^9, 3.504551248149308*^9}, {3.5051985130925627`*^9, 
   3.505198513541588*^9}, {3.505366069986941*^9, 3.505366070216941*^9}, {
   3.513366223994636*^9, 3.5133662302646446`*^9}, {3.5139051663653097`*^9, 
   3.5139051711233187`*^9}, {3.5151889136745615`*^9, 3.515188920434571*^9}, {
   3.515188965044633*^9, 3.515188966714636*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 3 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.5018603533666525`*^9, 
   3.5018603814467015`*^9}, {3.5018631639043903`*^9, 
   3.5018631661195946`*^9}, {3.503339847892067*^9, 3.5033398856753335`*^9}, {
   3.503339922928199*^9, 3.503339923833*^9}, 3.5033403420697355`*^9, 
   3.5034361145058737`*^9, {3.505183070135276*^9, 3.50518307090832*^9}, {
   3.505198278935169*^9, 3.5051982839434557`*^9}, {3.5051983264218855`*^9, 
   3.5051983332552767`*^9}, {3.5133633950906754`*^9, 3.513363395400676*^9}, {
   3.5133664834749994`*^9, 3.513366483835*^9}, {3.513366909285596*^9, 
   3.5133669106555977`*^9}, {3.5139030922216654`*^9, 3.513903130441733*^9}, {
   3.5141546134179544`*^9, 3.5141546577480164`*^9}}],

Cell[TextData[{
 "Rule b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", "0"}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.504550199987841*^9, 
   3.5045502011178427`*^9}, {3.504668995440073*^9, 3.504668998259234*^9}, {
   3.5046690756316595`*^9, 3.50466907669672*^9}, {3.5051984370962152`*^9, 
   3.505198438323286*^9}, 3.5051985102534*^9, 3.513366951165654*^9, {
   3.5137112712562037`*^9, 3.513711273611808*^9}, {3.513903935814748*^9, 
   3.513903946110766*^9}, {3.5141624999689956`*^9, 3.514162500218996*^9}, {
   3.515188969154639*^9, 3.51518897006464*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", " ", "C", " ", 
         RowBox[{"Cot", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"d", " ", 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"a", " ", "A"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", " ", "C"}]}], ")"}], " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095601616466413`*^9, 3.509560314986856*^9}, {
   3.509560348756903*^9, 3.50956035327691*^9}, {3.51017248196463*^9, 
   3.5101724878458405`*^9}, {3.5101727624843225`*^9, 3.510172767367131*^9}, {
   3.5101731141401405`*^9, 3.510173160207021*^9}, {3.5132779318843184`*^9, 
   3.513277940724331*^9}, {3.5132779893043985`*^9, 3.5132780561744924`*^9}, {
   3.513278092324543*^9, 3.513278109504567*^9}, 3.513278174804659*^9, {
   3.5132782333547406`*^9, 3.5132782367547455`*^9}, {3.513366402624886*^9, 
   3.5133664464549475`*^9}, {3.5133665204950514`*^9, 
   3.5133665447750854`*^9}, {3.5133665809651356`*^9, 
   3.5133666181851883`*^9}, {3.5133666937852936`*^9, 
   3.5133667435753636`*^9}, {3.513366809765456*^9, 3.513366810595457*^9}, {
   3.5139029572190285`*^9, 3.5139030699916267`*^9}, {3.513903165354594*^9, 
   3.5139032334643135`*^9}, 3.513903302656436*^9, {3.5139034404982777`*^9, 
   3.5139034954883747`*^9}, {3.513903773231262*^9, 3.5139037834180803`*^9}, {
   3.513903826364956*^9, 3.513903837066574*^9}, {3.51390387431944*^9, 
   3.5139038797014494`*^9}, {3.515188924484576*^9, 3.515188937224594*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "C", "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", " ", "+", " ", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A"}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"a", "*", "B"}], "-", 
               RowBox[{"b", "*", "C"}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.505198424716508*^9, 3.505198431349887*^9}, 3.505198763202868*^9, 
   3.505198799465942*^9, {3.505240055952962*^9, 3.5052400607429686`*^9}, {
   3.5133743738131633`*^9, 3.513374401066411*^9}, {3.513374433436468*^9, 
   3.51337446884853*^9}, {3.5137112775430145`*^9, 3.513711281021821*^9}, 
   3.513799475643965*^9, {3.513903922913525*^9, 3.513903992708048*^9}, {
   3.5139040227381*^9, 3.513904025733306*^9}, {3.5139040925482235`*^9, 
   3.513904126852683*^9}, {3.5139042664417286`*^9, 3.51390427876575*^9}, 
   3.514820784567521*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a_.", "+", 
       RowBox[{"b_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x_Symbol"}], "]"}], 
  " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "C", "*", 
     RowBox[{
      RowBox[{"Cot", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", " ", "+", " ", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A"}], "-", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"Sqrt", "[", 
          RowBox[{"a", "+", 
           RowBox[{"b", "*", 
            RowBox[{
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}], "^", 
             RowBox[{"(", 
              RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ",", "x"}], "]"}]}], 
     "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.505198424716508*^9, 3.505198431349887*^9}, 3.505198763202868*^9, 
   3.505198799465942*^9, {3.505240055952962*^9, 3.5052400607429686`*^9}, {
   3.5133743738131633`*^9, 3.513374401066411*^9}, {3.513374433436468*^9, 
   3.51337446884853*^9}, {3.5137112775430145`*^9, 3.513711281021821*^9}, 
   3.513799475643965*^9, {3.513903922913525*^9, 3.513903992708048*^9}, {
   3.5139040227381*^9, 3.513904025733306*^9}, {3.5139040925482235`*^9, 
   3.513904126852683*^9}, {3.5139042664417286`*^9, 3.51390427876575*^9}, {
   3.513904411943184*^9, 3.513904425608808*^9}},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox["Rule",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[" ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{
   StyleBox["c",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox[":",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   StyleBox["  ",
    FontFamily->"Arial",
    FontSize->20,
    FontWeight->"Plain"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "/", "2"}]], 
       RowBox[{"(", 
        RowBox[{"A", "+", 
         RowBox[{"B", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}], 
      SqrtBox[
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.497986248409831*^9, 
   3.497986248831032*^9}, {3.498495555818041*^9, 3.4984955663948593`*^9}, {
   3.498673619942603*^9, 3.498673628882616*^9}, {3.498673758742798*^9, 
   3.4986737649728065`*^9}, {3.5023763566098824`*^9, 3.502376360556689*^9}, {
   3.5025030477127104`*^9, 3.502503050973116*^9}, 3.5032820316843176`*^9, {
   3.5045512239492745`*^9, 3.504551248149308*^9}, {3.5051985130925627`*^9, 
   3.505198513541588*^9}, {3.505366069986941*^9, 3.505366070216941*^9}, {
   3.513366223994636*^9, 3.5133662302646446`*^9}, {3.5139051663653097`*^9, 
   3.5139051711233187`*^9}, {3.5139052198890038`*^9, 3.51390522335221*^9}, {
   3.5139117590079603`*^9, 3.513911771597978*^9}, {3.5141569349812045`*^9, 
   3.5141569355012054`*^9}, {3.515189024974717*^9, 3.5151890374147344`*^9}, {
   3.515189078554792*^9, 3.5151890957848163`*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Rule 2 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", 
   FractionBox["1", "2"]}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"n", "=", 
   RowBox[{"-", 
    FractionBox["1", "2"]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.5018603533666525`*^9, 
   3.5018603814467015`*^9}, {3.5018631639043903`*^9, 
   3.5018631661195946`*^9}, {3.503339847892067*^9, 3.5033398856753335`*^9}, {
   3.503339922928199*^9, 3.503339923833*^9}, 3.5033403420697355`*^9, 
   3.5034361145058737`*^9, {3.505183070135276*^9, 3.50518307090832*^9}, {
   3.505198278935169*^9, 3.5051982839434557`*^9}, {3.5051983264218855`*^9, 
   3.5051983332552767`*^9}, {3.5133633950906754`*^9, 3.513363395400676*^9}, {
   3.5133664834749994`*^9, 3.513366483835*^9}, {3.513366909285596*^9, 
   3.5133669106555977`*^9}, {3.5139030922216654`*^9, 3.513903130441733*^9}, {
   3.513905301461547*^9, 3.513905362005254*^9}, {3.513912077098406*^9, 
   3.5139120803984103`*^9}, {3.514156607130746*^9, 3.514156616060758*^9}}],

Cell[TextData[{
 "Rule c: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    RowBox[{"1", " ", "\[And]", " ", 
     RowBox[{
      SuperscriptBox["a", "2"], "-", 
      SuperscriptBox["b", "2"]}]}], "=", 
    RowBox[{
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"j", " ", "m"}]}], "=", 
     FractionBox["1", "2"]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.5032882255395966`*^9, 
   3.5032882353520136`*^9}, {3.503342656945004*^9, 3.503342658083806*^9}, {
   3.5033430130280294`*^9, 3.5033430176300373`*^9}, {3.5045501751978064`*^9, 
   3.5045501763378077`*^9}, {3.5046477778688097`*^9, 
   3.5046477849788194`*^9}, {3.504647915179002*^9, 3.5046479188090067`*^9}, {
   3.5046482353994503`*^9, 3.5046482441394625`*^9}, 3.504648571929921*^9, {
   3.5046611414588804`*^9, 3.504661141748881*^9}, 3.5046616085895343`*^9, {
   3.504665890797531*^9, 3.5046659026075473`*^9}, 3.504668082440852*^9, {
   3.5046682773029976`*^9, 3.5046682783160553`*^9}, 3.513362665319654*^9, {
   3.513718787767713*^9, 3.513718789717716*^9}, {3.514156477050564*^9, 
   3.514156493640587*^9}, {3.514156637260788*^9, 3.5141566378507886`*^9}, {
   3.515189070384781*^9, 3.5151890713647823`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "/", "2"}]], 
      RowBox[{"(", 
       RowBox[{"A", "+", 
        RowBox[{"B", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
        RowBox[{"C", " ", 
         SuperscriptBox[
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}]}], 
     SqrtBox[
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}]]], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"2", "A", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}], 
        RowBox[{"d", 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "/", "2"}]], 
         SqrtBox[
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]]}]}]}]}]}], "-", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"\[Integral]", 
    RowBox[{
     FractionBox[
      RowBox[{
       RowBox[{"b", " ", "A"}], "-", 
       RowBox[{"a", " ", "B"}], "-", 
       RowBox[{"a", " ", "C", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "/", "2"}]], 
       SqrtBox[
        RowBox[{"a", "+", 
         RowBox[{"b", " ", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}]}]}]]}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095542513719344`*^9, 3.509554323542035*^9}, {3.510172539341531*^9, 
   3.5101725420403357`*^9}, {3.510173494983609*^9, 3.5101735152636447`*^9}, {
   3.5132798504870043`*^9, 3.5132799133070927`*^9}, {3.5132800310872574`*^9, 
   3.5132800316472583`*^9}, {3.5132800984573517`*^9, 
   3.5132801027073574`*^9}, {3.513280379307745*^9, 3.513280408807786*^9}, {
   3.5133578143975763`*^9, 3.5133578188903847`*^9}, {3.513357985249077*^9, 
   3.5133579983686996`*^9}, {3.5133582236018953`*^9, 
   3.5133583392448983`*^9}, {3.513358464887519*^9, 3.5133584670559225`*^9}, {
   3.513906506090864*^9, 3.5139067311836596`*^9}, {3.513906901276759*^9, 
   3.51390690751677*^9}, {3.513906978933696*^9, 3.513906979464096*^9}, 
   3.513907026326579*^9, {3.513911739437933*^9, 3.5139117467979436`*^9}, {
   3.513911777717987*^9, 3.5139117788979883`*^9}, {3.5139120125883155`*^9, 
   3.513912017768323*^9}, {3.5139122525786514`*^9, 3.513912256488657*^9}, {
   3.5139122871987*^9, 3.5139123368987694`*^9}, {3.5139126067591476`*^9, 
   3.513912623739171*^9}, 3.5139127019492807`*^9, 3.5141566028207397`*^9, {
   3.5141566653608274`*^9, 3.51415666745083*^9}, {3.5151890304247246`*^9, 
   3.5151890466447477`*^9}, 3.515189094204814*^9, 3.5159769095275593`*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"B_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}], "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", "\n", "    ", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "A", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A"}], "-", 
            RowBox[{"a", "*", "B"}], "-", 
            RowBox[{"a", "*", "C", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
            "m"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", "x"}],
        "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.505198424716508*^9, 3.505198431349887*^9}, 3.505198763202868*^9, 
   3.505198799465942*^9, {3.505240055952962*^9, 3.5052400607429686`*^9}, {
   3.5133743738131633`*^9, 3.513374401066411*^9}, {3.513374433436468*^9, 
   3.51337446884853*^9}, {3.5137112775430145`*^9, 3.513711281021821*^9}, 
   3.513799475643965*^9, {3.513903922913525*^9, 3.513903992708048*^9}, {
   3.5139040227381*^9, 3.513904025733306*^9}, {3.5139040925482235`*^9, 
   3.513904126852683*^9}, {3.5139042664417286`*^9, 3.51390427876575*^9}, {
   3.5139070871042857`*^9, 3.51390722067172*^9}, {3.513912743319339*^9, 
   3.5139128127594357`*^9}, {3.514156686520857*^9, 3.5141567161308985`*^9}, {
   3.514156749540945*^9, 3.514156752670949*^9}, {3.5159769268279896`*^9, 
   3.515976940462414*^9}, 3.5168210517070155`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"A_", "+", 
        RowBox[{"C_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "/", 
      RowBox[{"Sqrt", "[", 
       RowBox[{"a_.", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}]}], ",", "x_Symbol"}], 
   "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "2"}], "*", "A", "*", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", "*", "x"}]}], "]"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}], 
        "*", 
        RowBox[{"Sqrt", "[", 
         RowBox[{"a", "+", 
          RowBox[{"b", "*", 
           RowBox[{"Csc", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}]}]}], "]"}]}], ")"}]}]}], " ", 
    "-", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", "a"}], ",", "\n", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"b", "*", "A"}], "-", 
            RowBox[{"a", "*", "C", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
            "m"}], "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"a", "+", 
             RowBox[{"b", "*", 
              RowBox[{
               RowBox[{"sin", "[", 
                RowBox[{"c", "+", 
                 RowBox[{"d", "*", "x"}]}], "]"}], "^", 
               RowBox[{"(", 
                RowBox[{"-", "1"}], ")"}]}]}]}], "]"}]}], ")"}]}], ",", "x"}],
        "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{"j", "^", "2"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "m", "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "m"}], "\[Equal]", 
     RowBox[{"1", "/", "2"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.505198424716508*^9, 3.505198431349887*^9}, 3.505198763202868*^9, 
   3.505198799465942*^9, {3.505240055952962*^9, 3.5052400607429686`*^9}, {
   3.5133743738131633`*^9, 3.513374401066411*^9}, {3.513374433436468*^9, 
   3.51337446884853*^9}, {3.5137112775430145`*^9, 3.513711281021821*^9}, 
   3.513799475643965*^9, {3.513903922913525*^9, 3.513903992708048*^9}, {
   3.5139040227381*^9, 3.513904025733306*^9}, {3.5139040925482235`*^9, 
   3.513904126852683*^9}, {3.5139042664417286`*^9, 3.51390427876575*^9}, {
   3.5139070871042857`*^9, 3.51390722067172*^9}, {3.513912743319339*^9, 
   3.5139128127594357`*^9}, {3.5139129283095975`*^9, 3.513912936619609*^9}, {
   3.513913002379701*^9, 3.513913006499707*^9}, {3.5139845725977654`*^9, 
   3.5139845769177713`*^9}, {3.514156198690174*^9, 3.5141562288002157`*^9}, {
   3.514156263110264*^9, 3.514156265030267*^9}, {3.514156305170323*^9, 
   3.5141563422903748`*^9}, {3.514156413630475*^9, 3.514156417880481*^9}, {
   3.515976930837197*^9, 3.5159769318199987`*^9}, 3.5168210517170153`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Rule", " ", "4"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.497986248409831*^9, 
   3.497986248831032*^9}, {3.498495555818041*^9, 3.4984955663948593`*^9}, {
   3.498673619942603*^9, 3.498673628882616*^9}, {3.498673758742798*^9, 
   3.4986737649728065`*^9}, {3.5023763566098824`*^9, 3.502376360556689*^9}, {
   3.5025030477127104`*^9, 3.502503050973116*^9}, 3.5032820316843176`*^9, {
   3.5045512239492745`*^9, 3.504551248149308*^9}, {3.5051985130925627`*^9, 
   3.505198513541588*^9}, {3.505366069986941*^9, 3.505366070216941*^9}, {
   3.513366223994636*^9, 3.5133662302646446`*^9}, {3.5139051746333246`*^9, 
   3.5139051747893248`*^9}, {3.5151891245848565`*^9, 3.515189126164859*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell[TextData[{
 "Derivation: Recurrence 7 with ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", "1"}]]],
 " plus recurrence 7 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "C"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"j", " ", "m"}], "=", "k"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.5018603533666525`*^9, 
   3.5018603814467015`*^9}, {3.5018631639043903`*^9, 
   3.5018631661195946`*^9}, {3.503339847892067*^9, 3.5033398856753335`*^9}, {
   3.503339922928199*^9, 3.503339923833*^9}, 3.5033403420697355`*^9, 
   3.5034361145058737`*^9, {3.505183070135276*^9, 3.50518307090832*^9}, {
   3.5133633793506536`*^9, 3.513363379610654*^9}, {3.513363413160701*^9, 
   3.513363413460701*^9}, {3.5133636561310415`*^9, 3.513363660441047*^9}, {
   3.513365428183522*^9, 3.513365443933544*^9}, {3.513366314794763*^9, 
   3.5133663204647713`*^9}}],

Cell[TextData[{
 "Rule 4a: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.504550199987841*^9, 
   3.5045502011178427`*^9}, {3.504668995440073*^9, 3.504668998259234*^9}, {
   3.5046690756316595`*^9, 3.50466907669672*^9}, 3.513365761243988*^9, {
   3.5137112144973035`*^9, 3.513711216244507*^9}, {3.513799733110691*^9, 
   3.513799733334704*^9}, {3.5141570766614027`*^9, 3.5141570768114033`*^9}, {
   3.514756641757801*^9, 3.514756641757801*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", 
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}]}], "-", 
          RowBox[{"a", " ", "B"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"a", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A", 
        RowBox[{"(", 
         RowBox[{"n", "+", "1"}], ")"}]}], "+", 
       RowBox[{"n", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "B"}], "-", 
          RowBox[{"a", " ", "C"}]}], ")"}]}], "+", 
       RowBox[{"b", " ", "C", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}], 
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.5006579216236315`*^9, 
   3.5006579403936577`*^9}, {3.5006580217937717`*^9, 3.5006580553038187`*^9}, 
   3.501042921876071*^9, {3.5032821068140497`*^9, 3.5032821100900555`*^9}, {
   3.5048104762440476`*^9, 3.504810478664051*^9}, {3.513365100533063*^9, 
   3.513365130133105*^9}, {3.5133652944033346`*^9, 3.513365315273364*^9}, {
   3.5151891269448595`*^9, 3.5151891290848627`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", "C"}], ")"}]}], "-", 
       RowBox[{"a", "*", "B"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{"n", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B"}], "-", 
               RowBox[{"a", "*", "C"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.5133652448932652`*^9, 3.5133652795733137`*^9}, 3.513365400713484*^9, {
   3.51371120704049*^9, 3.513711210753297*^9}, 3.513799487428639*^9, {
   3.5147566323877883`*^9, 3.5147566342577906`*^9}, 3.514817263752592*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "2"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}]}]}], ")"}], "^", "n_"}]}], ",",
     "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"b", "*", 
     RowBox[{"(", 
      RowBox[{"A", "+", "C"}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"a", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "-", 
            RowBox[{"a", "*", "C", "*", "n"}], "+", 
            RowBox[{"b", "*", "C", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}], "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{"sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.5133652448932652`*^9, 3.5133652795733137`*^9}, 3.513365400713484*^9, {
   3.513375859867774*^9, 3.513375860086174*^9}, {3.5133759034106393`*^9, 
   3.513375931210678*^9}, 3.5137993944703217`*^9, 3.5140029392944913`*^9, {
   3.5141541528973093`*^9, 3.51415415309731*^9}, {3.5141543221875467`*^9, 
   3.5141543232775483`*^9}, {3.5147566362077937`*^9, 3.514756637977796*^9}, 
   3.5148213919783716`*^9, 3.514823868025853*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Rule 1 with ",
 Cell[BoxData[
  RowBox[{"m", "=", "0"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"k", "=", 
   RowBox[{"-", "1"}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, 3.501878569854258*^9, 
   3.5033381093974123`*^9, {3.503342624699747*^9, 3.5033426251833477`*^9}, {
   3.503448463759152*^9, 3.503448463759152*^9}, {3.504647766288793*^9, 
   3.5046477668787937`*^9}, {3.504661003048687*^9, 3.5046610092586956`*^9}, {
   3.5051602282224827`*^9, 3.5051602386124973`*^9}, 3.505160363032671*^9, 
   3.5051604219327536`*^9, {3.5133572813048143`*^9, 3.513357282474816*^9}, {
   3.5133574128149986`*^9, 3.513357413114999*^9}, {3.513362650459633*^9, 
   3.5133626562096415`*^9}, {3.513363938231436*^9, 3.513363938621436*^9}, {
   3.513365636093813*^9, 3.5133657364039536`*^9}, {3.5141549942784877`*^9, 
   3.5141550336185427`*^9}, 3.5141550727585974`*^9}],

Cell[TextData[{
 "Rule 4b: If  ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox["a", "2"], "-", 
    SuperscriptBox["b", "2"]}], "=", 
   RowBox[{"0", " ", "\[And]", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.5032882255395966`*^9, 
   3.5032882353520136`*^9}, {3.503342656945004*^9, 3.503342658083806*^9}, {
   3.5033430130280294`*^9, 3.5033430176300373`*^9}, {3.5045501751978064`*^9, 
   3.5045501763378077`*^9}, {3.5046477778688097`*^9, 
   3.5046477849788194`*^9}, {3.504647915179002*^9, 3.5046479188090067`*^9}, {
   3.5046482353994503`*^9, 3.5046482441394625`*^9}, 3.504648571929921*^9, {
   3.5046611414588804`*^9, 3.504661141748881*^9}, 3.5046616085895343`*^9, {
   3.504665890797531*^9, 3.5046659026075473`*^9}, 3.504668082440852*^9, {
   3.5046682773029976`*^9, 3.5046682783160553`*^9}, 3.513362665319654*^9, {
   3.5133657464239674`*^9, 3.5133657636939917`*^9}, {3.513711239176547*^9, 
   3.5137112408145494`*^9}, {3.5137997365038853`*^9, 3.51379973711092*^9}, {
   3.514157080811409*^9, 3.514157081111409*^9}, {3.5147568032880273`*^9, 
   3.5147568039380283`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       RowBox[{"Csc", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "2"]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", 
           RowBox[{"(", 
            RowBox[{"A", "+", "C"}], ")"}]}]}], ")"}], 
        RowBox[{"Cot", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            RowBox[{"Csc", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", " ", "A", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"b", " ", "C", " ", "n"}], "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"b", " ", "A"}], "-", 
             RowBox[{"a", " ", "B"}]}], ")"}], 
           RowBox[{"(", 
            RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], 
        RowBox[{"Csc", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         RowBox[{"Csc", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.5133608764671497`*^9, 3.5133611341975107`*^9}, 
   3.513361221247632*^9, 3.513361389647868*^9, 3.5133614242179165`*^9, {
   3.513361473277985*^9, 3.5133615092980356`*^9}, {3.513361645148226*^9, 
   3.5133616486282306`*^9}, {3.513361686898284*^9, 3.5133617743684063`*^9}, {
   3.5133618315084867`*^9, 3.513361836948494*^9}, {3.5133618886085663`*^9, 
   3.513361892068571*^9}, {3.513362042418782*^9, 3.5133620451087856`*^9}, {
   3.5133621033488674`*^9, 3.513362110098877*^9}, {3.5133621564489417`*^9, 
   3.513362233499049*^9}, {3.5133623711192417`*^9, 3.5133624100492964`*^9}, {
   3.5133640833416395`*^9, 3.5133641369617143`*^9}, {3.513364357582023*^9, 
   3.513364364442033*^9}, {3.513365514173642*^9, 3.5133655401436787`*^9}, {
   3.5133657743040066`*^9, 3.513365808374054*^9}, {3.513365856844122*^9, 
   3.513365868304138*^9}, {3.5133661034944677`*^9, 3.513366125614498*^9}, {
   3.5137992885532637`*^9, 3.5137992918654537`*^9}, {3.515189145854886*^9, 
   3.515189160804907*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}]}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "*", "B"}], "-", 
       RowBox[{"b", "*", 
        RowBox[{"(", 
         RowBox[{"A", "+", "C"}], ")"}]}]}], ")"}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "C", "*", "n"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "-", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.5133652448932652`*^9, 3.5133652795733137`*^9}, 3.513365400713484*^9, {
   3.5133659593342657`*^9, 3.5133659750042877`*^9}, 3.5133661885145864`*^9, {
   3.5137112331861362`*^9, 3.51371123535454*^9}, 3.5137992862951345`*^9, 
   3.5137994674424963`*^9, {3.5147567942180147`*^9, 3.5147567961580176`*^9}, 
   3.514821364248333*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
         RowBox[{"(", 
          RowBox[{"-", "2"}], ")"}]}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", 
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", "n_"}]}], ",", 
    "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"A", "+", "C"}], ")"}]}], "*", 
     RowBox[{"Cot", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{"Csc", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}]}]}], ")"}], "^", "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "C", "*", "n"}], "-", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}]}], ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ",", "x"}], "]"}], "*", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", 
              RowBox[{"(", 
               RowBox[{"-", "1"}], ")"}]}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"RationalQ", "[", "n", "]"}], " ", "&&", " ", 
    RowBox[{"n", "<", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.5133652448932652`*^9, 3.5133652795733137`*^9}, 3.513365400713484*^9, {
   3.5133659593342657`*^9, 3.5133659750042877`*^9}, 3.5133661885145864`*^9, {
   3.5133759588507166`*^9, 3.513375990330761*^9}, {3.513799330140643*^9, 
   3.513799353332969*^9}, 3.513799397778511*^9, 3.514002992880585*^9, {
   3.514154156017314*^9, 3.5141541562073145`*^9}, {3.514154316387539*^9, 
   3.514154318057541*^9}, {3.514155132208681*^9, 3.514155135118685*^9}, {
   3.5147567983580203`*^9, 3.5147568000680227`*^9}, 3.5148213883483667`*^9, 
   3.514823871525858*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{
    RowBox[{"Rules", " ", "1"}], "-", "3"}],
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox[":",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  StyleBox["  ",
   FontFamily->"Arial",
   FontSize->20,
   FontWeight->"Plain"], 
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", "x"}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{
  3.477935275784027*^9, {3.477935350060832*^9, 3.477935352384173*^9}, {
   3.477935393803731*^9, 3.477935400102789*^9}, {3.477935515378547*^9, 
   3.47793552034569*^9}, 3.478120029940968*^9, {3.479318860690858*^9, 
   3.47931886615872*^9}, {3.4794185033278093`*^9, 3.479418503918659*^9}, 
   3.4795122294117584`*^9, {3.479615913307893*^9, 3.4796159352794867`*^9}, 
   3.4796160386581373`*^9, 3.4796867204045024`*^9, {3.4928025699585147`*^9, 
   3.492802570130115*^9}, 3.492822274480175*^9, 3.492825822242408*^9, {
   3.4940970615585365`*^9, 3.494097062168537*^9}, {3.496441349250718*^9, 
   3.496441349830719*^9}, 3.4964414848609076`*^9, 3.4965288067037597`*^9, {
   3.4975757333366117`*^9, 3.497575733766612*^9}, {3.4975758588567877`*^9, 
   3.4975759170868692`*^9}, {3.497577524211725*^9, 3.497577530181733*^9}, {
   3.497661528376972*^9, 3.4976615343361826`*^9}, 3.49766173212893*^9, 
   3.497661825183093*^9, 3.4976633966518536`*^9, {3.497986248409831*^9, 
   3.497986248831032*^9}, {3.498495555818041*^9, 3.4984955663948593`*^9}, {
   3.498673619942603*^9, 3.498673628882616*^9}, {3.498673758742798*^9, 
   3.4986737649728065`*^9}, {3.5023763566098824`*^9, 3.502376360556689*^9}, {
   3.5025030477127104`*^9, 3.502503050973116*^9}, 3.5032820316843176`*^9, 
   3.5033404673379555`*^9, 3.5045512393392963`*^9, {3.5046481829593763`*^9, 
   3.5046481831393766`*^9}, 3.5046612218489933`*^9, 3.513362729709744*^9, {
   3.513362827479881*^9, 3.5133628321698875`*^9}, {3.5151891868049436`*^9, 
   3.515189188014945*^9}},
 TextAlignment->Center,
 FontSize->16,
 FontWeight->"Bold"],

Cell["Derivation: Algebraic simplification", "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.5018603533666525`*^9, 
   3.5018603814467015`*^9}, {3.5018631639043903`*^9, 
   3.5018631661195946`*^9}, {3.503339847892067*^9, 3.5033398856753335`*^9}, {
   3.503339922928199*^9, 3.503339923833*^9}, 3.5033403420697355`*^9, 
   3.5034361145058737`*^9, {3.505183070135276*^9, 3.50518307090832*^9}, {
   3.5133633793506536`*^9, 3.513363379610654*^9}, {3.513363413160701*^9, 
   3.513363413460701*^9}, {3.5133636561310415`*^9, 3.513363660441047*^9}, {
   3.513365428183522*^9, 3.513365443933544*^9}, {3.513366314794763*^9, 
   3.5133663204647713`*^9}, {3.5137995456099668`*^9, 
   3.5137995592007437`*^9}, {3.513799757268073*^9, 3.5137997587461576`*^9}}],

Cell[TextData[{
 "Rule: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", "0"}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.504550199987841*^9, 
   3.5045502011178427`*^9}, {3.504668995440073*^9, 3.504668998259234*^9}, {
   3.5046690756316595`*^9, 3.50466907669672*^9}, 3.513365761243988*^9, {
   3.5137112144973035`*^9, 3.513711216244507*^9}, {3.513799674730352*^9, 
   3.513799674730352*^9}, {3.5137999291449037`*^9, 3.5137999291449037`*^9}, {
   3.5138003449976892`*^9, 3.5138003691300697`*^9}}],

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     SuperscriptBox[
      RowBox[{"Sin", "[", 
       RowBox[{"c", "+", 
        RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"B", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
     RowBox[{"C", " ", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], 
       RowBox[{"2", "k"}]]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"a", "+", 
      RowBox[{"b", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
   RowBox[{"\[DifferentialD]", 
    RowBox[{"x", "  ", "\[LongRightArrow]", "\[IndentingNewLine]", 
     RowBox[{"\[Integral]", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
        RowBox[{"m", "+", 
         RowBox[{"j", " ", "k"}]}]], 
       RowBox[{"(", 
        RowBox[{"B", "+", 
         RowBox[{"C", " ", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"a", "+", 
          RowBox[{"b", " ", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
       RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499404292486275*^9, 3.499404294656278*^9}, {3.4994047741669493`*^9, 
   3.4994047806169586`*^9}, {3.5003179797605133`*^9, 3.500317980041314*^9}, 
   3.5003181732532535`*^9, 3.500346671270671*^9, {3.500346791510839*^9, 
   3.5003467921708403`*^9}, {3.50034689968099*^9, 3.500346914681011*^9}, {
   3.500347270081509*^9, 3.5003472732915134`*^9}, {3.5006579216236315`*^9, 
   3.5006579403936577`*^9}, {3.5006580217937717`*^9, 3.5006580553038187`*^9}, 
   3.501042921876071*^9, {3.5032821068140497`*^9, 3.5032821100900555`*^9}, {
   3.5048104762440476`*^9, 3.504810478664051*^9}, {3.513365100533063*^9, 
   3.513365130133105*^9}, {3.5133652944033346`*^9, 3.513365315273364*^9}, {
   3.5137995720844812`*^9, 3.5137995832651205`*^9}, {3.513799627328641*^9, 
   3.513799665016796*^9}, {3.513799767994686*^9, 3.5137997844206257`*^9}, {
   3.513800232679265*^9, 3.5138002560506015`*^9}, {3.515189188474946*^9, 
   3.5151891907449493`*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{"Int", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"m", "+", 
         RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
      RowBox[{"(", 
       RowBox[{"B", "+", 
        RowBox[{"C", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "*", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}]}], ",", "x"}], "]"}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "B", ",", "C", ",", "m", ",", 
        "n"}], "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.503285948057996*^9}, 3.5032884947492695`*^9, {
   3.5034357402653494`*^9, 3.5034357686453896`*^9}, {3.504668988604682*^9, 
   3.5046689888026934`*^9}, {3.504669080043912*^9, 3.5046690810329685`*^9}, {
   3.5133652448932652`*^9, 3.5133652795733137`*^9}, 3.513365400713484*^9, {
   3.51371120704049*^9, 3.513711210753297*^9}, 3.513799487428639*^9, {
   3.5137996782605543`*^9, 3.5137996994617662`*^9}, 3.5137998030056887`*^9, {
   3.513799833217417*^9, 3.5137998406178403`*^9}, {3.5137998814621763`*^9, 
   3.5137999116769047`*^9}, {3.5138001340026207`*^9, 3.513800134665659*^9}, {
   3.5138002813800507`*^9, 3.5138002959068813`*^9}, {3.513800379526664*^9, 
   3.5138003961216135`*^9}, {3.513800474407091*^9, 3.513800494043214*^9}, {
   3.5159770093989344`*^9, 3.5159770105845366`*^9}, 3.516820871526763*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 12 plus recurrence 7 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "C"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "+", 
    RowBox[{"j", " ", "k"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, 3.501878569854258*^9, 
   3.5033381093974123`*^9, {3.503342624699747*^9, 3.5033426251833477`*^9}, {
   3.503448463759152*^9, 3.503448463759152*^9}, {3.504647766288793*^9, 
   3.5046477668787937`*^9}, {3.504661003048687*^9, 3.5046610092586956`*^9}, {
   3.5051602282224827`*^9, 3.5051602386124973`*^9}, 3.505160363032671*^9, 
   3.5051604219327536`*^9, {3.5133572813048143`*^9, 3.513357282474816*^9}, {
   3.5133574128149986`*^9, 3.513357413114999*^9}, {3.513362650459633*^9, 
   3.5133626562096415`*^9}, {3.513363938231436*^9, 3.513363938621436*^9}}],

Cell[TextData[{
 "Rule 1: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{"n", "\[LessEqual]", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.5032882255395966`*^9, 
   3.5032882353520136`*^9}, {3.503342656945004*^9, 3.503342658083806*^9}, {
   3.5033430130280294`*^9, 3.5033430176300373`*^9}, {3.5045501751978064`*^9, 
   3.5045501763378077`*^9}, {3.5046477778688097`*^9, 
   3.5046477849788194`*^9}, {3.504647915179002*^9, 3.5046479188090067`*^9}, {
   3.5046482353994503`*^9, 3.5046482441394625`*^9}, 3.504648571929921*^9, {
   3.5046611414588804`*^9, 3.504661141748881*^9}, 3.5046616085895343`*^9, {
   3.504665890797531*^9, 3.5046659026075473`*^9}, 3.504668082440852*^9, {
   3.5046682773029976`*^9, 3.5046682783160553`*^9}, 3.513362665319654*^9, {
   3.5137110306197805`*^9, 3.513711032522984*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"a", " ", "B"}], "-", 
          RowBox[{"b", " ", "A"}], "-", 
          RowBox[{"b", " ", "C"}]}], ")"}], 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"b", " ", "d", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "n"}], "+", "1"}], ")"}]}]]}]}]}]}], "+", 
  "\[IndentingNewLine]", 
  RowBox[{
   FractionBox["1", 
    RowBox[{
     SuperscriptBox["a", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "n"}], "+", "1"}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "n"}], "+", "1"}], ")"}]}], "-", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "B"}], "-", 
           RowBox[{"a", " ", "A"}], "-", 
           RowBox[{"a", " ", "C"}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "C", " ", "n"}], "-", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"b", " ", "A"}], "-", 
              RowBox[{"a", " ", "B"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{"a", " ", "B"}], "-", 
              RowBox[{"b", " ", "A"}], "-", 
              RowBox[{"b", " ", "C"}]}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], 
      RowBox[{"n", "+", "1"}]], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.502676353440346*^9, 
   3.50267644207047*^9}, {3.5040325316737633`*^9, 3.504032555885006*^9}, 
   3.5040712495285273`*^9, 3.5056768305258074`*^9, {3.5091340250266056`*^9, 
   3.5091340255166063`*^9}, {3.509134110686725*^9, 3.509134210656865*^9}, 
   3.5091358140991096`*^9, {3.5091363851499095`*^9, 3.5091363926999197`*^9}, {
   3.5091366480802774`*^9, 3.509136673460313*^9}, {3.509136756420429*^9, 
   3.509136781060464*^9}, {3.509136898910629*^9, 3.509136952490704*^9}, 
   3.509137023530803*^9, {3.5091371495009794`*^9, 3.509137183211027*^9}, {
   3.5091372666811438`*^9, 3.5091373023411937`*^9}, {3.509137374621295*^9, 
   3.5091373799413023`*^9}, {3.5091374289113708`*^9, 
   3.5091374307213736`*^9}, {3.509154869729108*^9, 3.5091548849591293`*^9}, {
   3.509154923779184*^9, 3.509154943939212*^9}, 3.5091550691693873`*^9, {
   3.5091550996494303`*^9, 3.5091551134994497`*^9}, {3.509155210989586*^9, 
   3.5091552779496794`*^9}, {3.509155484369969*^9, 3.5091554935699816`*^9}, {
   3.509156447241317*^9, 3.5091565172614145`*^9}, {3.509157219352398*^9, 
   3.5091572214624004`*^9}, {3.509200648372362*^9, 3.509200660899184*^9}, {
   3.5092402115853205`*^9, 3.5092402329885583`*^9}, {3.509240301316678*^9, 
   3.509240304764284*^9}, {3.509240391219636*^9, 3.5092403955564437`*^9}, 
   3.509479727927079*^9, {3.509479774026716*^9, 3.5094797761458373`*^9}, {
   3.509479865673958*^9, 3.5094799080873833`*^9}, 3.5094801863542995`*^9, {
   3.509560902857679*^9, 3.509560949397744*^9}, {3.5095609846277933`*^9, 
   3.509561101197957*^9}, {3.510172397162881*^9, 3.5101724322785425`*^9}, {
   3.513277045993078*^9, 3.5132771366732054`*^9}, {3.5132772238133273`*^9, 
   3.5132772240033274`*^9}, {3.513277256793373*^9, 3.513277286693415*^9}, 
   3.513277413733593*^9, {3.5133608764671497`*^9, 3.5133611341975107`*^9}, 
   3.513361221247632*^9, 3.513361389647868*^9, 3.5133614242179165`*^9, {
   3.513361473277985*^9, 3.5133615092980356`*^9}, {3.513361645148226*^9, 
   3.5133616486282306`*^9}, {3.513361686898284*^9, 3.5133617743684063`*^9}, {
   3.5133618315084867`*^9, 3.513361836948494*^9}, {3.5133618886085663`*^9, 
   3.513361892068571*^9}, {3.513362042418782*^9, 3.5133620451087856`*^9}, {
   3.5133621033488674`*^9, 3.513362110098877*^9}, {3.5133621564489417`*^9, 
   3.513362233499049*^9}, {3.5133623711192417`*^9, 3.5133624100492964`*^9}, {
   3.5151891941849537`*^9, 3.5151891968349576`*^9}, 3.51597703524818*^9},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"a", "*", "B"}], "-", 
       RowBox[{"b", "*", "A"}], "-", 
       RowBox[{"b", "*", "C"}]}], ")"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"b", "*", "d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "-", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "B"}], "-", 
               RowBox[{"a", "*", "A"}], "-", 
               RowBox[{"a", "*", "C"}]}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            "\n", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "C", "*", "n"}], "-", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"b", "*", "A"}], "-", 
                  RowBox[{"a", "*", "B"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"a", "*", "B"}], "-", 
                  RowBox[{"b", "*", "A"}], "-", 
                  RowBox[{"b", "*", "C"}]}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.5032859987736855`*^9}, 3.503288024252443*^9, {
   3.503288171017501*^9, 3.503288172421503*^9}, {3.503341611009965*^9, 
   3.503341645408025*^9}, {3.5033426638402157`*^9, 3.5033426688790245`*^9}, {
   3.5033429883019857`*^9, 3.503342995072398*^9}, {3.5034424372238855`*^9, 
   3.5034424486275053`*^9}, 3.504647847568907*^9, {3.5046479050189877`*^9, 
   3.5046479069789906`*^9}, {3.50464799969912*^9, 3.5046480037791257`*^9}, {
   3.504648218389426*^9, 3.50464822861944*^9}, {3.504650376712448*^9, 
   3.504650400642481*^9}, {3.504661447439309*^9, 3.504661450419313*^9}, {
   3.50466152664942*^9, 3.504661532049427*^9}, 3.5046616176795473`*^9, {
   3.504667601861365*^9, 3.504667610658868*^9}, 3.5133625475194893`*^9, 
   3.513362635969613*^9, {3.5133626767196703`*^9, 3.513362707549713*^9}, 
   3.51337577199282*^9, {3.5137110231317673`*^9, 3.5137110270317745`*^9}, 
   3.513800185841586*^9, {3.515977051909009*^9, 3.5159770649974327`*^9}, 
   3.516820871556763*^9, 3.51682396359402*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_"}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{"A", "+", "C"}], ")"}]}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}]}], " ", "+", 
    " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"a", "^", "2"}], "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], ")"}]}], ",", 
      "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"2", "*", "n"}], "+", "1"}], ")"}]}], "+", 
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            "\n", "        ", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "C", "*", "n"}], "-", 
               RowBox[{"b", "*", "A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "-", 
               RowBox[{"b", "*", 
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"n", "+", "1"}], ")"}]}]}], ",", "x"}], "]"}]}], "]"}]}], 
   " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"n", "\[LessEqual]", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.5032859987736855`*^9}, 3.503288024252443*^9, {
   3.503288171017501*^9, 3.503288172421503*^9}, {3.503341611009965*^9, 
   3.503341645408025*^9}, {3.5033426638402157`*^9, 3.5033426688790245`*^9}, {
   3.5033429883019857`*^9, 3.503342995072398*^9}, {3.5034424372238855`*^9, 
   3.5034424486275053`*^9}, 3.504647847568907*^9, {3.5046479050189877`*^9, 
   3.5046479069789906`*^9}, {3.50464799969912*^9, 3.5046480037791257`*^9}, {
   3.504648218389426*^9, 3.50464822861944*^9}, {3.504650376712448*^9, 
   3.504650400642481*^9}, {3.504661447439309*^9, 3.504661450419313*^9}, {
   3.50466152664942*^9, 3.504661532049427*^9}, 3.5046616176795473`*^9, {
   3.504667601861365*^9, 3.504667610658868*^9}, 3.5133625475194893`*^9, 
   3.513362635969613*^9, {3.5133626767196703`*^9, 3.513362707549713*^9}, {
   3.513375433753025*^9, 3.5133755050295506`*^9}, {3.5133755594112463`*^9, 
   3.5133755840280895`*^9}, 3.513375680498659*^9, {3.513718800668936*^9, 
   3.5137188028373394`*^9}, {3.51597709187628*^9, 3.515977094013483*^9}, 
   3.516820871566763*^9, 3.516823963606021*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 11 with ",
 Cell[BoxData[
  RowBox[{"B", "=", "0"}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, 
   3.502342991533648*^9, {3.5046608492784715`*^9, 3.5046608513184743`*^9}, {
   3.5051596782117124`*^9, 3.5051596837717204`*^9}, {3.5133572911248283`*^9, 
   3.513357291694829*^9}, {3.5133592246148367`*^9, 3.5133592260348387`*^9}}],

Cell[TextData[{
 "Rule 2: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "<", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{"n", ">", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.5032882255395966`*^9, 
   3.5032882353520136`*^9}, {3.503342656945004*^9, 3.503342658083806*^9}, {
   3.5033430130280294`*^9, 3.5033430176300373`*^9}, {3.503345585458547*^9, 
   3.503345585458547*^9}, {3.503348482624037*^9, 3.503348509378084*^9}, {
   3.504550180717814*^9, 3.504550182337816*^9}, {3.5046510946834526`*^9, 
   3.504651105393468*^9}, {3.5046511593735437`*^9, 3.5046511593735437`*^9}, {
   3.504660704838269*^9, 3.5046607132082806`*^9}, {3.5046608094384155`*^9, 
   3.5046608229084344`*^9}, 3.504661132878868*^9, 3.504668085111005*^9, {
   3.5046682373297114`*^9, 3.50466825846292*^9}, 3.513358624210599*^9, {
   3.5133591992348013`*^9, 3.5133591998848023`*^9}, {3.513711051929418*^9, 
   3.513711056921427*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      FractionBox[
       RowBox[{"A", " ", 
        RowBox[{"Cos", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          SuperscriptBox[
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
         RowBox[{"m", "+", 
          RowBox[{"j", " ", "k"}]}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"a", "+", 
           RowBox[{"b", " ", 
            SuperscriptBox[
             RowBox[{"Sin", "[", 
              RowBox[{"c", "+", 
               RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
       RowBox[{"d", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", " ", "k", " ", "m"}], "+", 
          FractionBox[
           RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", 
       FractionBox[
        RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
       RowBox[{"m", "+", 
        RowBox[{"j", " ", "k"}]}]], "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "B", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "-", 
        RowBox[{"b", " ", "A", " ", "n"}], "+", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"A", 
            RowBox[{"(", 
             RowBox[{"n", "+", "1"}], ")"}]}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"A", "+", "C"}], ")"}], 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", 
              FractionBox[
               RowBox[{"k", "+", "1"}], "2"]}], ")"}]}]}], ")"}], 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5013559487293763`*^9, 
   3.501355958849391*^9}, {3.502675715869453*^9, 3.502675816299594*^9}, {
   3.5026759394697657`*^9, 3.50267594261977*^9}, {3.5040325720154343`*^9, 
   3.5040325776782446`*^9}, 3.505344641413784*^9, {3.5053446931638565`*^9, 
   3.505344715023887*^9}, 3.5053535547652063`*^9, {3.509472692844695*^9, 
   3.509472735704147*^9}, {3.5094728451264057`*^9, 3.509472933684471*^9}, {
   3.5095542513719344`*^9, 3.509554323542035*^9}, {3.510172539341531*^9, 
   3.5101725420403357`*^9}, {3.510173494983609*^9, 3.5101735152636447`*^9}, {
   3.5132798504870043`*^9, 3.5132799133070927`*^9}, {3.5132800310872574`*^9, 
   3.5132800316472583`*^9}, {3.5132800984573517`*^9, 
   3.5132801027073574`*^9}, {3.513280379307745*^9, 3.513280408807786*^9}, {
   3.5133578143975763`*^9, 3.5133578188903847`*^9}, {3.513357985249077*^9, 
   3.5133579983686996`*^9}, {3.5133582236018953`*^9, 
   3.5133583392448983`*^9}, {3.513358464887519*^9, 3.5133584670559225`*^9}, {
   3.515189209244975*^9, 3.515189212204979*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "B", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "-", 
            RowBox[{"b", "*", "A", "*", "n"}], "+", 
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.5032859987736855`*^9}, 3.503288024252443*^9, {
   3.503288171017501*^9, 3.503288172421503*^9}, {3.503341611009965*^9, 
   3.503341645408025*^9}, {3.5033426638402157`*^9, 3.5033426688790245`*^9}, {
   3.5033429883019857`*^9, 3.503342995072398*^9}, {3.5033456976851444`*^9, 
   3.50334570099235*^9}, {3.5033457500232363`*^9, 3.5033457542820435`*^9}, {
   3.503348130313018*^9, 3.503348142169039*^9}, {3.503442420703456*^9, 
   3.503442427068267*^9}, {3.504649562101307*^9, 3.504649566141313*^9}, {
   3.504650165912153*^9, 3.504650169332157*^9}, {3.504651041133378*^9, 
   3.504651045393384*^9}, 3.504651153193535*^9, {3.5046607585183444`*^9, 
   3.5046608032084064`*^9}, {3.504661408149254*^9, 3.5046614375892954`*^9}, {
   3.5046629664614353`*^9, 3.5046630028214865`*^9}, {3.504667646862939*^9, 
   3.5046676550194054`*^9}, {3.5133585833853273`*^9, 3.5133586092033725`*^9}, 
   3.513359045940542*^9, {3.5133592036348076`*^9, 3.513359204804809*^9}, 
   3.513360714056922*^9, 3.5133607637569914`*^9, 3.513375775206425*^9, {
   3.513711043536603*^9, 3.5137110475302105`*^9}, 3.51380018975381*^9, {
   3.515977111594714*^9, 3.515977112717916*^9}, 3.5168208716067634`*^9, 
   3.5168239636410227`*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_"}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
          RowBox[{"(", 
           RowBox[{"m", "+", 
            RowBox[{"j", "*", "k"}]}], ")"}]}], "*", "\[IndentingNewLine]", 
         "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"-", "b"}], "*", "A", "*", "n"}], "+", 
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"A", "*", 
                RowBox[{"(", 
                 RowBox[{"n", "+", "1"}], ")"}]}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"A", "+", "C"}], ")"}], "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "<", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.5032859987736855`*^9}, 3.503288024252443*^9, {
   3.503288171017501*^9, 3.503288172421503*^9}, {3.503341611009965*^9, 
   3.503341645408025*^9}, {3.5033426638402157`*^9, 3.5033426688790245`*^9}, {
   3.5033429883019857`*^9, 3.503342995072398*^9}, {3.5033456976851444`*^9, 
   3.50334570099235*^9}, {3.5033457500232363`*^9, 3.5033457542820435`*^9}, {
   3.503348130313018*^9, 3.503348142169039*^9}, {3.503442420703456*^9, 
   3.503442427068267*^9}, {3.504649562101307*^9, 3.504649566141313*^9}, {
   3.504650165912153*^9, 3.504650169332157*^9}, {3.504651041133378*^9, 
   3.504651045393384*^9}, 3.504651153193535*^9, {3.5046607585183444`*^9, 
   3.5046608032084064`*^9}, {3.504661408149254*^9, 3.5046614375892954`*^9}, {
   3.5046629664614353`*^9, 3.5046630028214865`*^9}, {3.504667646862939*^9, 
   3.5046676550194054`*^9}, {3.5133585833853273`*^9, 3.5133586092033725`*^9}, 
   3.513359045940542*^9, {3.5133592036348076`*^9, 3.513359204804809*^9}, 
   3.513360714056922*^9, 3.5133607637569914`*^9, {3.5133749172557173`*^9, 
   3.5133749223413267`*^9}, 3.5133750711031876`*^9, 3.5133756866606693`*^9, {
   3.513718835597397*^9, 3.513718838452202*^9}, 3.516820871616763*^9, 
   3.5168239636520233`*^9},
 Background->GrayLevel[0.85]],

Cell["", "Subsubsection",
 CellDingbat->None,
 CellChangeTimes->{3.4796643211106243`*^9}],

Cell[TextData[{
 "Derivation: Recurrence 8 with ",
 Cell[BoxData[
  RowBox[{"A", "=", "0"}]]],
 ", ",
 Cell[BoxData[
  RowBox[{"B", "=", "C"}]]],
 " and ",
 Cell[BoxData[
  RowBox[{"m", "=", 
   RowBox[{"m", "+", 
    RowBox[{"j", " ", "k"}]}]}]]]
}], "Subsubsection",
 CellChangeTimes->{
  3.4964418130913677`*^9, {3.496442428087432*^9, 3.4964424330170403`*^9}, 
   3.496528894323882*^9, 3.4975761400971813`*^9, {3.4975778216221414`*^9, 
   3.497577829892153*^9}, {3.4975827089309845`*^9, 3.4975827138509912`*^9}, 
   3.497639710530856*^9, 3.4976397495153246`*^9, 3.4976637968549566`*^9, {
   3.497664121273126*^9, 3.4976641274819374`*^9}, {3.4976641823940334`*^9, 
   3.497664184390837*^9}, 3.497664250254153*^9, 3.497664775694276*^9, 
   3.4976649459685745`*^9, {3.49876308829488*^9, 3.4987630935048876`*^9}, {
   3.4987648355173264`*^9, 3.498764841027334*^9}, {3.4991797271436334`*^9, 
   3.4991797277208347`*^9}, {3.4992121758819084`*^9, 3.499212176211909*^9}, {
   3.4993573070196304`*^9, 3.4993573078152323`*^9}, 3.5013524902049417`*^9, 
   3.501621399618896*^9, 3.5016217326739454`*^9, 3.5016376139935837`*^9, 
   3.5016377276810865`*^9, {3.5017223219869995`*^9, 3.501722324888605*^9}, {
   3.5017223746994925`*^9, 3.5017223749958925`*^9}, {3.5017230174518213`*^9, 
   3.5017230272330384`*^9}, {3.501807621678917*^9, 3.5018076224433184`*^9}, {
   3.501808030072035*^9, 3.5018080306804357`*^9}, 3.501878569854258*^9, 
   3.5033381093974123`*^9, {3.503342624699747*^9, 3.5033426251833477`*^9}, {
   3.503448463759152*^9, 3.503448463759152*^9}, {3.513357302674844*^9, 
   3.5133573040748463`*^9}, {3.5133604698965807`*^9, 
   3.5133604714365826`*^9}, {3.513363931891427*^9, 3.5133639329514284`*^9}}],

Cell[TextData[{
 "Rule 3: If  ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["j", "2"], "=", 
   RowBox[{
    SuperscriptBox["k", "2"], "=", 
    RowBox[{
     RowBox[{"1", " ", "\[And]", " ", 
      RowBox[{
       SuperscriptBox["a", "2"], "-", 
       SuperscriptBox["b", "2"]}]}], "=", 
     RowBox[{"0", " ", "\[And]", " ", 
      RowBox[{
       RowBox[{
        RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
        FractionBox[
         RowBox[{"k", "+", "3"}], "2"]}], "\[NotEqual]", "0"}], " ", "\[And]",
       " ", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "\[GreaterEqual]", 
       RowBox[{"-", "1"}]}], " ", "\[And]", " ", 
      RowBox[{"n", ">", 
       RowBox[{"-", "1"}]}]}]}]}]}]]],
 ", then"
}], "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.4964417379912624`*^9, 3.4964417471112747`*^9}, {
   3.496441910111503*^9, 3.4964419275315275`*^9}, 3.496451213764926*^9, 
   3.496528833243797*^9, {3.4975777080419827`*^9, 3.4975777244120054`*^9}, {
   3.4975778737222147`*^9, 3.4975778945722437`*^9}, {3.4976396822792068`*^9, 
   3.49763968986082*^9}, {3.497639771433363*^9, 3.49763978104298*^9}, {
   3.4976638984111347`*^9, 3.4976639153215647`*^9}, {3.4976645939383564`*^9, 
   3.497664598805565*^9}, {3.4976646480080514`*^9, 3.4976646992229414`*^9}, {
   3.4976647966763124`*^9, 3.497664832415975*^9}, 3.497664903037299*^9, {
   3.4986779242986293`*^9, 3.498677947778662*^9}, {3.499179738750054*^9, 
   3.499179740902858*^9}, {3.499213316063504*^9, 3.4992133345435305`*^9}, {
   3.499358051967739*^9, 3.4993580717017736`*^9}, {3.4993638312082148`*^9, 
   3.499363839028226*^9}, {3.499368533262825*^9, 3.499368534762827*^9}, {
   3.500319714354707*^9, 3.500319719674714*^9}, {3.500321207536797*^9, 
   3.5003212188668127`*^9}, {3.5006579695436983`*^9, 3.5006579872737236`*^9}, 
   3.500658071043841*^9, {3.500658346374226*^9, 3.5006583478942285`*^9}, 
   3.5032824113109846`*^9, {3.5032824648346786`*^9, 3.503282468063884*^9}, {
   3.5032843334763603`*^9, 3.503284338296769*^9}, {3.503284722176643*^9, 
   3.503284722176643*^9}, {3.5032847700531273`*^9, 3.5032847726115313`*^9}, {
   3.5032859516928024`*^9, 3.5032859536896057`*^9}, {3.5032882255395966`*^9, 
   3.5032882353520136`*^9}, {3.503342656945004*^9, 3.503342658083806*^9}, {
   3.5033430130280294`*^9, 3.5033430176300373`*^9}, {3.5045501751978064`*^9, 
   3.5045501763378077`*^9}, {3.5046481630193486`*^9, 3.5046481701793585`*^9}, 
   3.504648546009885*^9, 3.504661230359005*^9, {3.5046658636174927`*^9, 
   3.5046658689375*^9}, {3.5133604514365544`*^9, 3.5133604590265656`*^9}, {
   3.5137110781218643`*^9, 3.5137110802746677`*^9}, {3.513718873365063*^9, 
   3.513718873365063*^9}, {3.513793062938179*^9, 3.5137930731037607`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Integral]", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"(", 
      SuperscriptBox[
       RowBox[{"Sin", "[", 
        RowBox[{"c", "+", 
         RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
    RowBox[{"(", 
     RowBox[{"A", "+", 
      RowBox[{"B", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], "k"]}], "+", 
      RowBox[{"C", " ", 
       SuperscriptBox[
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", " ", "x"}]}], "]"}], 
        RowBox[{"2", "k"}]]}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"a", "+", 
       RowBox[{"b", " ", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
    RowBox[{"\[DifferentialD]", 
     RowBox[{"x", "  ", "\[LongRightArrow]", "  ", "\[IndentingNewLine]", 
      RowBox[{"-", 
       FractionBox[
        RowBox[{"C", " ", 
         RowBox[{"Cos", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], 
         SuperscriptBox[
          RowBox[{"(", 
           SuperscriptBox[
            RowBox[{"Sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], 
          RowBox[{"m", "+", 
           RowBox[{"j", " ", "k"}]}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", " ", 
             SuperscriptBox[
              RowBox[{"Sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"]}], 
        RowBox[{"d", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
           FractionBox[
            RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]]}]}]}]}]}], "+", 
  RowBox[{
   FractionBox["1", 
    RowBox[{"a", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
       FractionBox[
        RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]], 
   RowBox[{"\[Integral]", 
    RowBox[{
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        SuperscriptBox[
         RowBox[{"Sin", "[", 
          RowBox[{"c", "+", 
           RowBox[{"d", " ", "x"}]}], "]"}], "j"], ")"}], "m"], 
      "\[CenterDot]", "\[IndentingNewLine]", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"a", " ", "A", " ", 
         RowBox[{"(", 
          RowBox[{"n", "+", "1"}], ")"}]}], "+", 
        RowBox[{"a", 
         RowBox[{"(", 
          RowBox[{"A", "+", "C"}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", " ", "k", " ", "m"}], "+", 
           FractionBox[
            RowBox[{"k", "+", "1"}], "2"]}], ")"}]}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"b", " ", "C", " ", "n"}], "+", 
           RowBox[{"a", " ", "B", " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"j", " ", "k", " ", "m"}], "+", "n", "+", 
              FractionBox[
               RowBox[{"k", "+", "3"}], "2"]}], ")"}]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}]}], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"a", "+", 
        RowBox[{"b", " ", 
         SuperscriptBox[
          RowBox[{"Sin", "[", 
           RowBox[{"c", "+", 
            RowBox[{"d", " ", "x"}]}], "]"}], "k"]}]}], ")"}], "n"], 
     RowBox[{"\[DifferentialD]", "x"}]}]}]}]}]], "Subsubtitle",
 CellDingbat->None,
 CellChangeTimes->{{3.4796579732027807`*^9, 3.479658002474872*^9}, {
   3.4796580599975853`*^9, 3.4796580609489536`*^9}, {3.479658295195784*^9, 
   3.47965829684816*^9}, 3.4796611938939075`*^9, 3.4796613924794593`*^9, {
   3.479661443342597*^9, 3.479661446647349*^9}, {3.479661576554146*^9, 
   3.479661589302477*^9}, 3.479661847553824*^9, {3.4796622294729967`*^9, 
   3.4796622450654173`*^9}, {3.479686720424531*^9, 3.4796867204345455`*^9}, {
   3.4796874646646957`*^9, 3.4796874745589232`*^9}, {3.492826573513727*^9, 
   3.492826578630536*^9}, {3.4928267070863624`*^9, 3.492826707460763*^9}, 
   3.4928267903497095`*^9, {3.492829799151373*^9, 3.4928299617216005`*^9}, {
   3.4940972077187414`*^9, 3.4940972347887793`*^9}, {3.496441851501421*^9, 
   3.496441872881451*^9}, {3.496528916553913*^9, 3.4965289272239285`*^9}, {
   3.497576165747217*^9, 3.4975761801372375`*^9}, {3.497577761382057*^9, 
   3.4975777938921027`*^9}, 3.49763959300025*^9, 3.497639634480723*^9, 
   3.4976398417426867`*^9, {3.49766381031778*^9, 3.4976638350282235`*^9}, {
   3.49766435104593*^9, 3.497664390373599*^9}, {3.4976647278489914`*^9, 
   3.4976647419046164`*^9}, {3.497664869980841*^9, 3.497664887437272*^9}, {
   3.498761171082196*^9, 3.498761171082196*^9}, {3.4987645684369526`*^9, 
   3.4987646442070584`*^9}, {3.49883740188522*^9, 3.4988375207310295`*^9}, {
   3.498837939529365*^9, 3.498837958467798*^9}, 3.498875518717125*^9, {
   3.4991794250335026`*^9, 3.499179452879552*^9}, {3.4991796787211485`*^9, 
   3.499179681529153*^9}, {3.4991961982482667`*^9, 3.4991962392763386`*^9}, {
   3.499196653100665*^9, 3.4991966955639396`*^9}, {3.499197135282312*^9, 
   3.499197176918785*^9}, {3.499197690444487*^9, 3.499197694048094*^9}, {
   3.499212356332161*^9, 3.4992123865622034`*^9}, {3.499212421412252*^9, 
   3.499212423032254*^9}, {3.4992126233625345`*^9, 3.499212696332637*^9}, {
   3.499357348905704*^9, 3.4993574380910606`*^9}, {3.4993588274861555`*^9, 
   3.4993589039462624`*^9}, {3.499359110096551*^9, 3.4993591137965565`*^9}, {
   3.4993752824791145`*^9, 3.4993752993591385`*^9}, {3.4994041904561324`*^9, 
   3.4994041927361355`*^9}, {3.499404246686211*^9, 3.499404275156251*^9}, {
   3.499404742476905*^9, 3.4994047525269194`*^9}, {3.500317978262911*^9, 
   3.500317979417313*^9}, 3.500318137887991*^9, {3.5030149938276834`*^9, 
   3.5030149992252927`*^9}, 3.505344641363784*^9, {3.505344693023856*^9, 
   3.5053447149738874`*^9}, 3.5053535459551945`*^9, {3.5094696268243294`*^9, 
   3.509469698805446*^9}, {3.509469791674758*^9, 3.509469802752392*^9}, {
   3.509469914234768*^9, 3.5094699164558954`*^9}, {3.509470445456152*^9, 
   3.509470483604334*^9}, {3.5094706454305897`*^9, 3.50947066641179*^9}, {
   3.5094707559529114`*^9, 3.5094707698497066`*^9}, 3.5094708527324467`*^9, {
   3.5094710367959747`*^9, 3.5094710383620644`*^9}, 3.5094711873785877`*^9, 
   3.5094801966418877`*^9, {3.5095601616466413`*^9, 3.509560314986856*^9}, {
   3.509560348756903*^9, 3.50956035327691*^9}, {3.51017248196463*^9, 
   3.5101724878458405`*^9}, {3.5101727624843225`*^9, 3.510172767367131*^9}, {
   3.5101731141401405`*^9, 3.510173160207021*^9}, {3.5132779318843184`*^9, 
   3.513277940724331*^9}, {3.5132779893043985`*^9, 3.5132780561744924`*^9}, {
   3.513278092324543*^9, 3.513278109504567*^9}, 3.513278174804659*^9, {
   3.5132782333547406`*^9, 3.5132782367547455`*^9}, {3.5133597985456405`*^9, 
   3.513359972565884*^9}, {3.5133600677860174`*^9, 3.513360087746045*^9}, {
   3.5133601957261963`*^9, 3.513360340246399*^9}, {3.5151892179249873`*^9, 
   3.51518922019499*^9}},
 TextAlignment->Center,
 FontSize->12,
 FontWeight->"Bold"],

Cell["Program code:", "Subsubsection",
 CellDingbat->"\[FilledSmallSquare]",
 CellChangeTimes->{{3.4794189093216*^9, 3.479418932274605*^9}, {
   3.479418981395237*^9, 3.4794189822564754`*^9}, {3.4794192068193808`*^9, 
   3.4794192077607346`*^9}, 3.479420089138093*^9, {3.479420130978256*^9, 
   3.4794201410627565`*^9}, {3.479420560345656*^9, 3.479420578171288*^9}, {
   3.479420683943381*^9, 3.4794206847645617`*^9}, {3.4794210347678413`*^9, 
   3.4794210503903055`*^9}, 3.4803613662913427`*^9, {3.480361406058525*^9, 
   3.48036141974821*^9}, {3.4803614672865667`*^9, 3.480361474717252*^9}, 
   3.4807050675119123`*^9, {3.492804314166378*^9, 3.4928043441496305`*^9}, {
   3.4928044532166224`*^9, 3.492804453513023*^9}, {3.492805162266266*^9, 
   3.492805165713872*^9}, {3.5003184730429688`*^9, 3.50031848112298*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_", "+", 
       RowBox[{"B_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}], "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     "\n", "    ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{"b", "*", "C", "*", "n"}], "+", 
               RowBox[{"a", "*", "B", "*", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
                  RowBox[{
                   RowBox[{"(", 
                    RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}]}], 
              ")"}], "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "B", ",", "C"}], 
       "}"}], ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.5032859987736855`*^9}, 3.503288024252443*^9, {
   3.503288171017501*^9, 3.503288172421503*^9}, {3.503341611009965*^9, 
   3.503341645408025*^9}, {3.5033426638402157`*^9, 3.5033426688790245`*^9}, {
   3.5033429883019857`*^9, 3.503342995072398*^9}, {3.5034424372238855`*^9, 
   3.5034424486275053`*^9}, {3.5046479958591146`*^9, 3.504648019519148*^9}, {
   3.5046481361593113`*^9, 3.504648145389324*^9}, {3.504650416062503*^9, 
   3.504650421722511*^9}, 3.504651122953492*^9, {3.504661457669323*^9, 
   3.5046614770893507`*^9}, {3.504661653349597*^9, 3.504661656739602*^9}, 
   3.5133594652351737`*^9, {3.513360499076621*^9, 3.513360507966634*^9}, 
   3.5133605865067434`*^9, 3.5133607172169266`*^9, 3.5133757777180295`*^9, {
   3.513711071351452*^9, 3.5137110737538567`*^9}, {3.5137930379607506`*^9, 
   3.513793039597844*^9}, 3.5138001918899317`*^9, {3.515977139565563*^9, 
   3.515977140485965*^9}, 3.5168208716567636`*^9, 3.516823963687025*^9},
 Background->GrayLevel[0.85]],

Cell[BoxData[
 RowBox[{
  RowBox[{"Int", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"sin", "[", 
         RowBox[{"c_.", "+", 
          RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "j_."}], ")"}], "^", 
      "m_."}], "*", 
     RowBox[{"(", 
      RowBox[{"A_.", "+", 
       RowBox[{"C_.", "*", 
        RowBox[{
         RowBox[{"sin", "[", 
          RowBox[{"c_.", "+", 
           RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k2_"}]}]}], ")"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"a_", "+", 
        RowBox[{"b_.", "*", 
         RowBox[{
          RowBox[{"sin", "[", 
           RowBox[{"c_.", "+", 
            RowBox[{"d_.", "*", "x_"}]}], "]"}], "^", "k_."}]}]}], ")"}], "^",
       "n_."}]}], ",", "x_Symbol"}], "]"}], " ", ":=", "\n", "  ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "C"}], "*", 
     RowBox[{"Cos", "[", 
      RowBox[{"c", "+", 
       RowBox[{"d", "*", "x"}]}], "]"}], "*", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"c", "+", 
          RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", 
      RowBox[{"(", 
       RowBox[{"m", "+", 
        RowBox[{"j", "*", "k"}]}], ")"}]}], "*", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"a", "+", 
         RowBox[{"b", "*", 
          RowBox[{
           RowBox[{"Sin", "[", 
            RowBox[{"c", "+", 
             RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
       "n"}], "/", 
      RowBox[{"(", 
       RowBox[{"d", "*", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}]}], 
    " ", "+", " ", "\n", "  ", 
    RowBox[{"Dist", "[", 
     RowBox[{
      RowBox[{"1", "/", 
       RowBox[{"(", 
        RowBox[{"a", "*", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], ")"}]}], ")"}]}], 
      ",", "\[IndentingNewLine]", "    ", 
      RowBox[{"Int", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"sin", "[", 
             RowBox[{"c", "+", 
              RowBox[{"d", "*", "x"}]}], "]"}], "^", "j"}], ")"}], "^", "m"}],
          "*", "\[IndentingNewLine]", "      ", 
         RowBox[{"Sim", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"a", "*", "A", "*", 
             RowBox[{"(", 
              RowBox[{"n", "+", "1"}], ")"}]}], "+", 
            RowBox[{"a", "*", 
             RowBox[{"(", 
              RowBox[{"A", "+", "C"}], ")"}], "*", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"j", "*", "k", "*", "m"}], "+", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{"k", "+", "1"}], ")"}], "/", "2"}]}], ")"}]}], "+", 
            RowBox[{"b", "*", "C", "*", "n", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ",", "x"}], 
          "]"}], "*", "\[IndentingNewLine]", "      ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"a", "+", 
            RowBox[{"b", "*", 
             RowBox[{
              RowBox[{"sin", "[", 
               RowBox[{"c", "+", 
                RowBox[{"d", "*", "x"}]}], "]"}], "^", "k"}]}]}], ")"}], "^", 
          "n"}]}], ",", "x"}], "]"}]}], "]"}]}], " ", "/;", "\n", 
   RowBox[{
    RowBox[{"FreeQ", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "A", ",", "C"}], "}"}],
       ",", "x"}], "]"}], " ", "&&", " ", 
    RowBox[{"OneQ", "[", 
     RowBox[{
      RowBox[{"j", "^", "2"}], ",", 
      RowBox[{"k", "^", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{"k2", "===", 
     RowBox[{"2", "*", "k"}]}], " ", "&&", " ", 
    RowBox[{"ZeroQ", "[", 
     RowBox[{
      RowBox[{"a", "^", "2"}], "-", 
      RowBox[{"b", "^", "2"}]}], "]"}], " ", "&&", " ", "\n", "  ", 
    RowBox[{"RationalQ", "[", 
     RowBox[{"m", ",", "n"}], "]"}], " ", "&&", " ", 
    RowBox[{"NonzeroQ", "[", 
     RowBox[{
      RowBox[{"j", "*", "k", "*", "m"}], "+", "n", "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"k", "+", "3"}], ")"}], "/", "2"}]}], "]"}], " ", "&&", " ", 
    RowBox[{
     RowBox[{"j", "*", "k", "*", "m"}], "\[GreaterEqual]", 
     RowBox[{"-", "1"}]}], " ", "&&", " ", 
    RowBox[{"n", ">", 
     RowBox[{"-", "1"}]}]}]}]}]], "Code",
 CellChangeTimes->{{3.494097279728842*^9, 3.494097309778884*^9}, 
   3.496441834031397*^9, 3.496442095051762*^9, 3.496528791863739*^9, 
   3.496528888643874*^9, 3.497575939976901*^9, 3.4975761146971455`*^9, 
   3.4975775509417624`*^9, 3.497577752792045*^9, 3.4975834953320856`*^9, 
   3.4976395861674376`*^9, 3.4976397432129135`*^9, 3.4976633737510133`*^9, 
   3.497663791067346*^9, 3.497664242469739*^9, {3.49766439658241*^9, 
   3.497664398470013*^9}, 3.497664769079864*^9, {3.4986774515679674`*^9, 
   3.49867746046798*^9}, {3.498761171092196*^9, 3.4987611711021957`*^9}, {
   3.4987647642072268`*^9, 3.4987647797772484`*^9}, {3.4987662584793186`*^9, 
   3.498766258909319*^9}, {3.4987729599087005`*^9, 3.4987729607687016`*^9}, 
   3.4988018581019883`*^9, {3.499179579551774*^9, 3.4991796094414263`*^9}, {
   3.499179689157567*^9, 3.499179691637971*^9}, {3.4991797663621025`*^9, 
   3.499179767407304*^9}, {3.499179868308281*^9, 3.499179869805884*^9}, 
   3.499180259000168*^9, {3.499197395157969*^9, 3.499197401054779*^9}, {
   3.499212499112361*^9, 3.49921251269238*^9}, {3.499212715522664*^9, 
   3.4992127382126956`*^9}, {3.4992128038327875`*^9, 
   3.4992128061327906`*^9}, {3.499213982604438*^9, 3.499214025174497*^9}, {
   3.499214066304555*^9, 3.499214072114563*^9}, {3.4992145411652193`*^9, 
   3.4992145475152283`*^9}, {3.4993575889901257`*^9, 
   3.4993576670838633`*^9}, {3.499365544950614*^9, 3.4993655661406436`*^9}, {
   3.4993657073008413`*^9, 3.499365707870842*^9}, 3.4993699181547637`*^9, {
   3.5003179803689146`*^9, 3.500317981117716*^9}, {3.5003185042030125`*^9, 
   3.5003185122330236`*^9}, {3.500319341644185*^9, 3.500319361824213*^9}, {
   3.5003214645171566`*^9, 3.500321470987166*^9}, {3.500346709430724*^9, 
   3.5003467096207247`*^9}, {3.5003469262310276`*^9, 3.500346943681052*^9}, {
   3.500347283661528*^9, 3.5003472916715393`*^9}, 3.5003511720069714`*^9, {
   3.5004321452599263`*^9, 3.500432146579002*^9}, {3.5006580987338796`*^9, 
   3.500658104833888*^9}, 3.5006581787039914`*^9, 3.5006582507440925`*^9, {
   3.500658340704218*^9, 3.500658342374221*^9}, {3.5032823981913614`*^9, 
   3.5032824239782066`*^9}, {3.503284295973894*^9, 3.5032842999675016`*^9}, 
   3.50328472618585*^9, {3.5032847612235117`*^9, 3.5032847653107185`*^9}, {
   3.5032859419427853`*^9, 3.5032859987736855`*^9}, 3.503288024252443*^9, {
   3.503288171017501*^9, 3.503288172421503*^9}, {3.503341611009965*^9, 
   3.503341645408025*^9}, {3.5033426638402157`*^9, 3.5033426688790245`*^9}, {
   3.5033429883019857`*^9, 3.503342995072398*^9}, {3.5034424372238855`*^9, 
   3.5034424486275053`*^9}, {3.5046479958591146`*^9, 3.504648019519148*^9}, {
   3.5046481361593113`*^9, 3.504648145389324*^9}, {3.504650416062503*^9, 
   3.504650421722511*^9}, 3.504651122953492*^9, {3.504661457669323*^9, 
   3.5046614770893507`*^9}, {3.504661653349597*^9, 3.504661656739602*^9}, 
   3.5133594652351737`*^9, {3.513360499076621*^9, 3.513360507966634*^9}, 
   3.5133605865067434`*^9, 3.5133607172169266`*^9, {3.5133749308901415`*^9, 
   3.513374934821348*^9}, {3.513375094581229*^9, 3.513375099120837*^9}, 
   3.5133756900770755`*^9, {3.513718880712676*^9, 3.5137188833802805`*^9}, {
   3.5137929747501354`*^9, 3.5137929920801263`*^9}, 3.5168208716667633`*^9, 
   3.5168239636980257`*^9},
 Background->GrayLevel[0.85]],

Cell["", "PageBreak",
 PageBreakBelow->True]
}, Closed]]
},
AutoGeneratedPackage->Automatic,
CellGrouping->Manual,
WindowSize->{1912, 961},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PageHeaders->{{
   Cell[
    TextData[{
      Cell[
       TextData[{
         CounterBox["Page"]}], "PageNumber"], " ", 
      Cell[
      " ", "Header", CellFrame -> {{0.5, 0}, {0, 0}}, CellFrameMargins -> 4], 
      Cell[
       TextData[{
         ValueBox["FileName"]}], "Header"]}], 
    CellMargins -> {{0, Inherited}, {Inherited, Inherited}}], None, None}, {
  "Integration Rules for (sin^j)^m (A+B sin^k+C sin^(2k)) (a+a sin^k)^n", 
   None, None}},
PrintingOptions->{"FacingPages"->False,
"FirstPageHeader"->True,
"PrintCellBrackets"->False,
"PrintMultipleHorizontalPages"->False,
"PrintRegistrationMarks"->False,
"PrintingMargins"->28.8},
Magnification->1.3999998569488525`,
FrontEndVersion->"7.0 for Microsoft Windows (64-bit) (February 18, 2009)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 4059, 85, 157, "Title"],
Cell[CellGroupData[{
Cell[4629, 109, 1694, 26, 45, "Subsubtitle"],
Cell[6326, 137, 1497, 34, 529, "Input"],
Cell[7826, 173, 1554, 26, 278, "Text"],
Cell[9383, 201, 44, 1, 4, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[9464, 207, 2712, 67, 73, "Subsubtitle"],
Cell[12179, 276, 546, 8, 181, "Subsubsection"],
Cell[12728, 286, 1327, 34, 230, "Subsubsection"],
Cell[14058, 322, 1025, 19, 134, "Subsubsection"],
Cell[15086, 343, 1630, 28, 134, "Subsubsection"],
Cell[16719, 373, 4253, 91, 349, "Subsubtitle"],
Cell[20975, 466, 821, 11, 181, "Subsubsection"],
Cell[21799, 479, 5209, 119, 820, "Code"],
Cell[27011, 600, 4959, 111, 741, "Code"],
Cell[31973, 713, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[32054, 719, 2807, 69, 80, "Subsubtitle"],
Cell[34864, 790, 1965, 37, 340, "Subsubsection"],
Cell[36832, 829, 2596, 41, 187, "Subsubsection"],
Cell[39431, 872, 5798, 115, 530, "Subsubtitle"],
Cell[45232, 989, 818, 11, 253, "Subsubsection"],
Cell[46053, 1002, 5886, 132, 961, "Code"],
Cell[51942, 1136, 5529, 120, 1037, "Code"],
Cell[57474, 1258, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[57555, 1264, 3253, 80, 88, "Subsubtitle"],
Cell[60811, 1346, 2105, 40, 243, "Subsubsection"],
Cell[62919, 1388, 3178, 53, 202, "Subsubsection"],
Cell[66100, 1443, 6454, 135, 810, "Subsubtitle"],
Cell[72557, 1580, 818, 11, 181, "Subsubsection"],
Cell[73378, 1593, 7078, 162, 956, "Code"],
Cell[80459, 1757, 7015, 156, 874, "Code"],
Cell[87477, 1915, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[87558, 1921, 2684, 63, 63, "Subsubtitle"],
Cell[90245, 1986, 1980, 41, 261, "Subsubsection"],
Cell[92228, 2029, 2613, 43, 187, "Subsubsection"],
Cell[94844, 2074, 5184, 120, 1279, "Subsubtitle"],
Cell[100031, 2196, 818, 11, 253, "Subsubsection"],
Cell[100852, 2209, 6087, 142, 1147, "Code"],
Cell[106942, 2353, 5896, 132, 1223, "Code"],
Cell[112841, 2487, 89, 2, 253, "Subsubsection"],
Cell[112933, 2491, 1995, 33, 187, "Subsubsection"],
Cell[114931, 2526, 3109, 50, 187, "Subsubsection"],
Cell[118043, 2578, 7872, 158, 1279, "Subsubtitle"],
Cell[125918, 2738, 818, 11, 253, "Subsubsection"],
Cell[126739, 2751, 6744, 161, 1147, "Code"],
Cell[133486, 2914, 6469, 149, 1223, "Code"],
Cell[139958, 3065, 44, 1, 20, "PageBreak",
 PageBreakBelow->True]
}, Closed]],
Cell[CellGroupData[{
Cell[140039, 3071, 2865, 71, 63, "Subsubtitle"],
Cell[142907, 3144, 1749, 24, 181, "Subsubsection"],
Cell[144659, 3170, 2679, 45, 181, "Subsubsection"],
Cell[147341, 3217, 4691, 99, 537, "Subsubtitle"],
Cell[152035, 3318, 818, 11, 181, "Subsubsection"],
Cell[152856, 3331, 5584, 122, 687, "Code"],
Cell[158443, 3455, 89, 2, 181, "Subsubsection"],
Cell[158535, 3459, 1971, 35, 134, "Subsubsection"],
Cell[160509, 3496, 3070, 52, 181, "Subsubsection"],
Cell[163582, 3550, 9199, 202, 1251, "Subsubtitle"],
Cell[172784, 3754, 818, 11, 181, "Subsubsection"],
Cell[173605, 3767, 8971, 216, 1492, "Code"],
Cell[182579, 3985, 8385, 198, 1413, "Code"],
Cell[190967, 4185, 89, 2, 181, "Subsubsection"],
Cell[191059, 4189, 1429, 22, 134, "Subsubsection"],
Cell[192491, 4213, 3237, 56, 181, "Subsubsection"],
Cell[195731, 4271, 7052, 163, 1128, "Subsubtitle"],
Cell[202786, 4436, 818, 11, 181, "Subsubsection"],
Cell[203607, 4449, 8701, 206, 1359, "Code"],
Cell[212311, 4657, 8242, 193, 1279, "Code"],
Cell[220556, 4852, 89, 2, 181, "Subsubsection"],
Cell[220648, 4856, 1704, 32, 134, "Subsubsection"],
Cell[222355, 4890, 3283, 59, 202, "Subsubsection"],
Cell[225641, 4951, 7339, 166, 1128, "Subsubtitle"],
Cell[232983, 5119, 818, 11, 181, "Subsubsection"],
Cell[233804, 5132, 8634, 206, 1359, "Code"],
Cell[242441, 5340, 8042, 189, 1279, "Code"],
Cell[250486, 5531, 44, 1, 15, "PageBreak",
 PageBreakBelow->True]
}, Closed]]
}
]
*)

(* End of internal cache information *)
